/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.NetworkAccess;
import nl.colorize.multimedialib.scene.ActorSystem;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.Stage;
import nl.colorize.multimedialib.scene.Stage3D;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.Platform;
import nl.colorize.util.PlatformFamily;

public class SceneContext
implements Updatable {
    private Stage stage;
    private InputDevice inputDevice;
    private MediaLoader mediaLoader;
    private NetworkAccess network;
    private Scene activeScene;
    private List<ActorSystem> activeSceneSystems;
    private Scene requestedScene;
    private List<ActorSystem> requestedSceneSystems;
    private FrameStats frameStats;

    public SceneContext(DisplayMode displayMode, InputDevice input, MediaLoader mediaLoader, NetworkAccess network) {
        this.stage = new Stage(displayMode.canvas());
        this.inputDevice = input;
        this.mediaLoader = mediaLoader;
        this.network = network;
        this.activeScene = null;
        this.activeSceneSystems = new ArrayList<ActorSystem>();
        this.requestedScene = null;
        this.requestedSceneSystems = new ArrayList<ActorSystem>();
        this.frameStats = new FrameStats(displayMode.framerate());
    }

    @Override
    public void update(float deltaTime) {
        Preconditions.checkState((this.activeScene != null || this.requestedScene != null ? 1 : 0) != 0, (Object)"No initial scene requested");
        this.updateFrame(deltaTime);
    }

    private void updateFrame(float deltaTime) {
        this.stage.update(deltaTime);
        if (this.requestedScene != null) {
            this.activateRequestedScene();
        }
        this.updateActiveScene(deltaTime);
    }

    private void updateActiveScene(float deltaTime) {
        this.activeScene.update(this, deltaTime);
        for (int i = this.activeSceneSystems.size() - 1; i >= 0; --i) {
            ActorSystem system = this.activeSceneSystems.get(i);
            system.update(this, deltaTime);
            if (!system.isCompleted()) continue;
            this.activeSceneSystems.remove(system);
        }
    }

    private void activateRequestedScene() {
        if (this.activeScene != null) {
            this.activeScene.end(this);
            this.activeSceneSystems.clear();
            this.stage.clear();
        }
        this.activeScene = this.requestedScene;
        this.activeSceneSystems.addAll(this.requestedSceneSystems);
        this.requestedScene = null;
        ImmutableList uninitializedSystems = ImmutableList.copyOf(this.requestedSceneSystems);
        this.requestedSceneSystems.clear();
        this.activeScene.start(this);
        uninitializedSystems.forEach(system -> system.init(this));
    }

    public void changeScene(Scene requestedScene) {
        Preconditions.checkState((this.requestedScene == null ? 1 : 0) != 0, (Object)("Requested " + requestedScene + ", but already requested " + this.requestedScene));
        this.requestedScene = requestedScene;
    }

    public void attach(ActorSystem system) {
        if (this.requestedScene == null) {
            this.activeSceneSystems.add(0, system);
            system.init(this);
        } else {
            this.requestedSceneSystems.add(0, system);
        }
    }

    public void attach(Updatable system) {
        this.attach(ActorSystem.wrap(system));
    }

    @Deprecated
    public void delay(float duration, Runnable action) {
        this.attach(ActorSystem.delay(duration, action));
    }

    public Stage getStage() {
        return this.stage;
    }

    public Stage3D getStage3D() {
        return (Stage3D)this.stage;
    }

    public Canvas getCanvas() {
        return this.stage.getCanvas();
    }

    public InputDevice getInputDevice() {
        return this.inputDevice;
    }

    public MediaLoader getMediaLoader() {
        return this.mediaLoader;
    }

    public NetworkAccess getNetwork() {
        return this.network;
    }

    public PlatformFamily getPlatform() {
        return this.mediaLoader.getPlatformFamily();
    }

    public String getDistributionChannel() {
        return switch (this.getPlatform()) {
            case PlatformFamily.IOS -> "App Store";
            case PlatformFamily.ANDROID -> "Google Play";
            case PlatformFamily.MAC -> "Mac App Store";
            case PlatformFamily.TEAVM -> "Web";
            default -> "Download";
        };
    }

    public String getScreenSize() {
        Canvas canvas = this.stage.getCanvas();
        int width = Math.round((float)canvas.getWidth() * canvas.getZoomLevel());
        int height = Math.round((float)canvas.getHeight() * canvas.getZoomLevel());
        return width + "x" + height;
    }

    public FrameStats getFrameStats() {
        return this.frameStats;
    }

    public boolean canQuit() {
        return Platform.isWindows() || Platform.isMac();
    }

    public void quit() {
        if (this.canQuit()) {
            System.exit(0);
        }
    }
}

