/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Graphic2D;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Text;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.scene.Layer;
import nl.colorize.multimedialib.scene.StageObserver;
import nl.colorize.multimedialib.scene.StageVisitor;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.LogHelper;

public class Stage
implements Updatable {
    private Canvas canvas;
    private ColorRGB backgroundColor;
    private Map<String, Layer> layers;
    private Multimap<String, Graphic2D> layerGraphics;
    private Set<Graphic2D> allGraphics;
    private List<StageObserver> observers;
    public static final Layer DEFAULT_LAYER = Layer.DEFAULT;
    private static final Logger LOGGER = LogHelper.getLogger(Stage.class);

    protected Stage(Canvas canvas) {
        this.canvas = canvas;
        this.backgroundColor = ColorRGB.BLACK;
        this.layers = new LinkedHashMap<String, Layer>();
        this.layerGraphics = ArrayListMultimap.create();
        this.allGraphics = new HashSet<Graphic2D>();
        this.observers = new ArrayList<StageObserver>();
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setBackgroundColor(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ColorRGB getBackgroundColor() {
        return this.backgroundColor;
    }

    public Layer addLayer(String name) {
        Preconditions.checkArgument((!this.layers.containsKey(name) ? 1 : 0) != 0, (Object)("Layer already exists: " + name));
        Layer layer = new Layer(name);
        this.layers.put(name, layer);
        return layer;
    }

    public void add(Layer layer, Graphic2D graphic) {
        this.add(layer.getName(), graphic);
    }

    public void add(String layerName, Graphic2D graphic) {
        this.ensureDefaultLayerExists();
        Layer layer = this.layers.get(layerName);
        Preconditions.checkArgument((layer != null ? 1 : 0) != 0, (Object)("Cannot add graphics to nonexistent layer: " + layerName));
        Preconditions.checkState((!this.contains(graphic) ? 1 : 0) != 0, (Object)("Stage already contains " + graphic));
        this.layerGraphics.put((Object)layerName, (Object)graphic);
        this.allGraphics.add(graphic);
        this.observers.forEach(observer -> observer.onGraphicAdded(layer, graphic));
    }

    public void add(Graphic2D graphic) {
        this.ensureDefaultLayerExists();
        this.add(DEFAULT_LAYER, graphic);
    }

    private void ensureDefaultLayerExists() {
        if (!this.layers.containsKey(DEFAULT_LAYER.getName())) {
            this.layers.put(DEFAULT_LAYER.getName(), DEFAULT_LAYER);
        }
    }

    public void remove(Layer layer, Graphic2D graphic) {
        this.remove(layer.getName(), graphic);
    }

    public void remove(String layerName, Graphic2D graphic) {
        if (this.layerGraphics.remove((Object)layerName, (Object)graphic)) {
            this.allGraphics.remove(graphic);
            Layer layer = this.layers.get(layerName);
            this.observers.forEach(observer -> observer.onGraphicRemoved(layer, graphic));
        }
    }

    public void remove(Graphic2D graphic) {
        for (Map.Entry<String, Layer> entry : this.layers.entrySet()) {
            if (!this.layerGraphics.remove((Object)entry.getKey(), (Object)graphic)) continue;
            Layer layer = entry.getValue();
            this.observers.forEach(observer -> observer.onGraphicRemoved(layer, graphic));
        }
        this.allGraphics.remove(graphic);
    }

    public Iterable<Layer> getLayers() {
        return this.layers.values();
    }

    public Layer getLayer(String name) {
        Preconditions.checkArgument((boolean)this.layers.containsKey(name), (Object)("No such layer: " + name));
        return this.layers.get(name);
    }

    public boolean hasLayer(String layer) {
        return this.layers.containsKey(layer);
    }

    public boolean contains(Layer layer, Graphic2D graphic) {
        return this.layerGraphics.containsEntry((Object)layer.getName(), (Object)graphic);
    }

    public boolean contains(String layerName, Graphic2D graphic) {
        return this.layerGraphics.containsEntry((Object)layerName, (Object)graphic);
    }

    public boolean contains(Graphic2D graphic) {
        return this.allGraphics.contains(graphic);
    }

    public void visit(StageVisitor visitor) {
        visitor.preVisitStage(this);
        visitor.drawBackground(this.backgroundColor);
        for (Layer layer : this.getLayers()) {
            visitor.preVisitLayer(layer);
            for (Graphic2D graphic : this.layerGraphics.get((Object)layer.getName())) {
                boolean visible = graphic.isVisible();
                visitor.preVisitGraphic(graphic, visible);
                if (!visible) continue;
                this.visitGraphic(graphic, visitor);
                visitor.postVisitGraphic(graphic);
            }
            visitor.postVisitLayer(layer);
        }
        visitor.postVisitStage(this);
    }

    private void visitGraphic(Graphic2D graphic, StageVisitor visitor) {
        if (graphic instanceof Sprite) {
            visitor.drawSprite((Sprite)graphic);
        } else if (graphic instanceof Primitive) {
            this.visitPrimitive((Primitive)graphic, visitor);
        } else if (graphic instanceof Text) {
            visitor.drawText((Text)graphic);
        } else {
            LOGGER.warning("Stage contains unknown graphics type: " + graphic);
        }
    }

    private void visitPrimitive(Primitive graphic, StageVisitor visitor) {
        Shape displayedShape = graphic.getShape().reposition(graphic.getPosition());
        switch (graphic.getShapeType()) {
            case 1: {
                visitor.drawLine(graphic, (Line)displayedShape);
                break;
            }
            case 2: {
                visitor.drawRect(graphic, (Rect)displayedShape);
                break;
            }
            case 3: {
                visitor.drawCircle(graphic, (Circle)displayedShape);
                break;
            }
            case 4: {
                visitor.drawPolygon(graphic, (Polygon)displayedShape);
                break;
            }
            default: {
                LOGGER.warning("Stage contains unknown primitive type: " + graphic);
            }
        }
    }

    @Override
    public void update(float deltaTime) {
        for (Graphic2D graphic : this.layerGraphics.values()) {
            graphic.update(deltaTime);
        }
    }

    public void clear() {
        this.layers.clear();
        this.layerGraphics.clear();
        this.observers.forEach(observer -> observer.onStageCleared());
    }

    public void addObserver(StageObserver observer) {
        this.observers.add(observer);
    }

    public void removeObserver(StageObserver observer) {
        this.observers.remove(observer);
    }
}

