/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.PolygonModel;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.scene.Stage;

public class Stage3D
extends Stage {
    private Point3D cameraPosition = new Point3D(10.0f, 10.0f, 10.0f);
    private Point3D cameraTarget = new Point3D(0.0f, 0.0f, 0.0f);
    private ColorRGB ambientLight = new ColorRGB(100, 100, 100);
    private ColorRGB lightColor = new ColorRGB(200, 200, 200);
    private Point3D lightPosition = new Point3D(-1.0f, -0.8f, -0.2f);
    private List<PolygonModel> models = new ArrayList<PolygonModel>();
    private GeometryBuilder geometryBuilder;

    protected Stage3D(Canvas canvas, GeometryBuilder geometryBuilder) {
        super(canvas);
        this.geometryBuilder = geometryBuilder;
    }

    public void moveCamera(Point3D position, Point3D target) {
        this.cameraPosition = position;
        this.cameraTarget = target;
    }

    public Point3D getCameraPosition() {
        return this.cameraPosition;
    }

    public Point3D getCameraTarget() {
        return this.cameraTarget;
    }

    public void changeAmbientLight(ColorRGB color) {
        this.ambientLight = color;
    }

    public ColorRGB getAmbientLight() {
        return this.ambientLight;
    }

    public void changeLight(ColorRGB color, Point3D target) {
        this.lightColor = color;
        this.lightPosition = target;
    }

    public ColorRGB getLightColor() {
        return this.lightColor;
    }

    public Point3D getLightPosition() {
        return this.lightPosition;
    }

    public void add(PolygonModel model) {
        this.models.add(model);
    }

    public void remove(PolygonModel model) {
        this.models.remove(model);
    }

    public Iterable<PolygonModel> getModels() {
        return this.models;
    }

    public GeometryBuilder getGeometryBuilder() {
        return this.geometryBuilder;
    }

    @Override
    public void update(float deltaTime) {
        super.update(deltaTime);
        for (PolygonModel model : this.models) {
            model.update(deltaTime);
        }
    }

    @Override
    public void clear() {
        this.models.clear();
        super.clear();
    }
}

