/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.graphics.Align;
import nl.colorize.multimedialib.graphics.Animation;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.OutlineFont;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Text;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.scene.DisplayObject;
import nl.colorize.multimedialib.scene.Layer;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public class Effect {
    protected DisplayObject displayObject = new DisplayObject();
    protected Timeline timeline;
    private Point2D position;
    private Transform transform;
    private List<Consumer<Float>> timelineCallbacks;

    protected Effect(Timeline timeline) {
        this.timeline = timeline;
        this.position = new Point2D(0.0f, 0.0f);
        this.transform = new Transform();
        this.timelineCallbacks = new ArrayList<Consumer<Float>>();
        this.displayObject.withTimelineHandler(timeline, value -> {
            for (Consumer<Float> timelineCallback : this.timelineCallbacks) {
                timelineCallback.accept((Float)value);
            }
        });
    }

    public Effect withLayer(Layer layer) {
        this.displayObject.withLayer(layer);
        return this;
    }

    public Effect withLayer(String layerName) {
        this.displayObject.withLayer(layerName);
        return this;
    }

    @Deprecated
    public Effect modify(Consumer<Float> modifier) {
        this.timelineCallbacks.add(modifier);
        return this;
    }

    public Effect modifyFrameUpdate(Updatable modifier) {
        this.displayObject.withFrameHandler(modifier);
        return this;
    }

    @Deprecated
    public Effect onComplete(Runnable observer) {
        this.displayObject.withTerminationHandler(observer);
        return this;
    }

    @Deprecated
    public Effect setPosition(Point2D position) {
        this.position = position;
        return this;
    }

    @Deprecated
    public Effect setPosition(float x, float y) {
        this.position.set(x, y);
        return this;
    }

    @Deprecated
    public Point2D getPosition() {
        return this.position;
    }

    @Deprecated
    public Effect setTransform(Transform transform) {
        this.transform = transform;
        return this;
    }

    @Deprecated
    public Transform getTransform() {
        return this.transform;
    }

    public void attachTo(SceneContext context) {
        this.displayObject.attachTo(context);
    }

    @Deprecated
    @VisibleForTesting
    protected void update(SceneContext context, float deltaTime) {
        this.displayObject.update(context, deltaTime);
    }

    public static Effect forSprite(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect(timeline);
        effect.displayObject.withGraphics(sprite);
        effect.modifyFrameUpdate(deltaTime -> {
            sprite.update(deltaTime);
            sprite.setPosition(effect.getPosition());
            sprite.setTransform(effect.getTransform());
        });
        return effect;
    }

    public static Effect forSpriteX(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getPosition().setX(value.floatValue()));
        return effect;
    }

    public static Effect forSpriteY(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getPosition().setY(value.floatValue()));
        return effect;
    }

    public static Effect forSpriteRotation(Sprite sprite, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 360.0f);
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getTransform().setRotation(Math.round(value.floatValue())));
        return effect;
    }

    public static Effect forSpriteAlpha(Sprite sprite, Timeline timeline) {
        Effect effect = Effect.forSprite(sprite, timeline);
        effect.modify(value -> effect.getTransform().setAlpha(Math.round(value.floatValue())));
        return effect;
    }

    public static Effect forAnimation(Animation anim, Timeline timeline) {
        Sprite sprite = new Sprite();
        sprite.addState("_effect", anim);
        return Effect.forSprite(sprite, timeline);
    }

    public static Effect forAnimation(Animation anim, float duration) {
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 0.0f);
        return Effect.forAnimation(anim, timeline);
    }

    public static Effect forAnimation(Animation anim) {
        return Effect.forAnimation(anim, anim.getDuration());
    }

    public static Effect forImage(Image image, Timeline timeline) {
        return Effect.forAnimation(new Animation(image), timeline);
    }

    public static Effect forImage(Image image, float duration) {
        return Effect.forAnimation(new Animation(image), duration);
    }

    public static Effect forPrimitive(Primitive primitive, Timeline timeline) {
        Effect effect = new Effect(timeline);
        effect.displayObject.withGraphics(primitive);
        effect.modifyFrameUpdate(deltaTime -> {
            primitive.update(deltaTime);
            primitive.getPosition().set(effect.getPosition());
        });
        return effect;
    }

    public static Effect forText(String text, OutlineFont font, Align align, Timeline timeline) {
        Text textObject = new Text(text, font, align);
        Effect effect = new Effect(timeline);
        effect.displayObject.withGraphics(textObject);
        effect.modifyFrameUpdate(deltaTime -> {
            textObject.getPosition().set(effect.getPosition());
            textObject.setAlpha(effect.getTransform().getAlpha());
        });
        return effect;
    }

    public static Effect forTextAppear(String text, OutlineFont font, Align align, float duration) {
        Preconditions.checkArgument((text.length() > 0 ? 1 : 0) != 0, (Object)"Cannot animate empty text");
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, (float)text.length());
        Text textObject = new Text(text, font, align);
        Effect effect = new Effect(timeline);
        effect.displayObject.withGraphics(textObject);
        effect.modifyFrameUpdate(deltaTime -> {
            textObject.setText(text.substring(0, (int)timeline.getValue()));
            textObject.getPosition().set(effect.getPosition());
            textObject.setAlpha(effect.getTransform().getAlpha());
        });
        return effect;
    }

    public static Effect forTextAlpha(String text, OutlineFont font, Align align, Timeline timeline) {
        Effect effect = Effect.forText(text, font, align, timeline);
        effect.modify(value -> effect.getTransform().setAlpha(Math.round(value.floatValue())));
        return effect;
    }
}

