/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene.effect;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import nl.colorize.multimedialib.graphics.ColorRGB;
import nl.colorize.multimedialib.graphics.Image;
import nl.colorize.multimedialib.graphics.Primitive;
import nl.colorize.multimedialib.graphics.Sprite;
import nl.colorize.multimedialib.graphics.Transform;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.effect.Effect;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.animation.Timeline;

public class TransitionEffect
extends Effect {
    private boolean reverse;
    private Canvas canvas;
    private Image particleImage;
    private float duration;
    private ColorRGB fillColor;
    private List<List<Particle>> particles;
    private static final FilePointer PARTICLE_IMAGE = new FilePointer("transition-effect.png");
    private static final Logger LOGGER = LogHelper.getLogger(TransitionEffect.class);

    private TransitionEffect(boolean reverse, Canvas canvas, Image particleImage, float duration) {
        super(new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(duration, 1.0f));
        this.reverse = reverse;
        this.canvas = canvas;
        this.particleImage = particleImage;
        this.duration = duration;
        this.particles = this.generateParticles();
        this.modifyFrameUpdate(this::updateParticles);
    }

    private List<List<Particle>> generateParticles() {
        ArrayList<List<Particle>> particles = new ArrayList<List<Particle>>();
        if (Platform.isTeaVM()) {
            LOGGER.warning("Particle effects are disabled on TeaVM due to performance issues");
            return Collections.emptyList();
        }
        for (int x = 0; x <= this.canvas.getWidth(); x += this.particleImage.getWidth()) {
            ArrayList<Particle> column = new ArrayList<Particle>();
            particles.add(column);
            for (int y = 0; y <= this.canvas.getHeight(); y += this.particleImage.getHeight()) {
                float pDelay = (float)(column.size() + 1) * 0.04f;
                Particle particle = new Particle(x, y, pDelay, this.duration * 0.5f);
                particle.sprite = new Sprite(this.particleImage);
                column.add(particle);
                this.displayObject.withGraphics(particle.sprite);
            }
        }
        return particles;
    }

    private void updateParticles(float deltaTime) {
        for (List<Particle> column : this.particles) {
            for (Particle particle : column) {
                particle.timeline.movePlayhead(deltaTime);
                particle.sprite.setPosition(particle.position);
                particle.sprite.setTransform(this.getParticleTransform(particle));
            }
        }
        if (this.fillColor != null && this.timeline.getDelta() >= 0.8f) {
            this.displayObject.extendGraphics(Primitive.of(this.canvas.getBounds(), this.fillColor));
        }
    }

    private Transform getParticleTransform(Particle particle) {
        float delta = particle.timeline.getValue();
        if (this.reverse) {
            delta = 1.0f - delta;
        }
        float scale = Math.max(delta * 200.0f, 1.0f);
        return Transform.withScale(scale);
    }

    public static TransitionEffect obscure(SceneContext context, ColorRGB color, float duration) {
        Image particleImage = context.getMediaLoader().loadImage(PARTICLE_IMAGE).tint(color);
        Canvas canvas = context.getCanvas();
        TransitionEffect effect = new TransitionEffect(false, canvas, particleImage, duration);
        effect.fillColor = color;
        return effect;
    }

    public static TransitionEffect obscure(Canvas canvas, Image particleImage, float duration) {
        return new TransitionEffect(false, canvas, particleImage, duration);
    }

    public static TransitionEffect reveal(SceneContext context, ColorRGB color, float duration) {
        Image particleImage = context.getMediaLoader().loadImage(PARTICLE_IMAGE).tint(color);
        Canvas canvas = context.getCanvas();
        return new TransitionEffect(true, canvas, particleImage, duration);
    }

    public static TransitionEffect reveal(Canvas canvas, Image particleImage, float duration) {
        return new TransitionEffect(true, canvas, particleImage, duration);
    }

    private static class Particle {
        private Point2D position;
        private Timeline timeline;
        private Sprite sprite;

        public Particle(float x, float y, float delay, float duration) {
            this.position = new Point2D(x, y);
            this.timeline = new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(delay, 0.0f).addKeyFrame(delay + duration, 1.0f);
        }
    }
}

