/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import nl.colorize.util.FileUtils;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Tuple;
import nl.colorize.util.cli.CommandLineArgumentParser;

public class CopyrightUpdateTool {
    protected File dir;
    protected String startCopyrightYear;
    protected String newCopyrightYear;
    protected String license;
    private static final Pattern COPYRIGHT_PATTERN = Pattern.compile("Copyright\\s+(20\\d+)(\\s*[-,]\\s*)?(20\\d+)?");
    private static final List<String> SUPPORTED_FILE_EXTENSIONS = ImmutableList.of((Object)".java", (Object)".js", (Object)".ts", (Object)".php", (Object)".py", (Object)".swift", (Object)".gradle", (Object)".md", (Object)".properties", (Object)".json", (Object)".yaml");
    private static final List<String> EXCLUDE_DIRS = ImmutableList.of((Object)"/build/", (Object)"/lib/", (Object)"/node_modules/", (Object)"/.git/", (Object)"/.gradle/", (Object)"/.idea/", (Object)"/out/");
    private static final Charset FILE_CHARSET = Charsets.UTF_8;
    private static final String LEAVE_MARKER = "leave";
    private static final Logger LOGGER = LogHelper.getLogger(CopyrightUpdateTool.class);

    public static void main(String[] args) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("CopyrightUpdateTool").add("--source", "Source code directory").add("--startyear", "Copyright start year or 'leave' for existing").add("--currentyear", "Current year for copyright statement").addOptional("--license", null, "Override copyright license type");
        argParser.parseArgs(args);
        CopyrightUpdateTool tool = new CopyrightUpdateTool();
        tool.dir = argParser.getDir("source");
        tool.startCopyrightYear = argParser.get("startyear");
        tool.newCopyrightYear = argParser.get("currentyear");
        tool.license = argParser.get("license");
        tool.run();
    }

    protected void run() {
        List<File> files = this.findFiles(this.dir);
        LOGGER.info("Updating copyright statements");
        LOGGER.info("Found " + files.size() + " files");
        for (File file : files) {
            LOGGER.info("Updating " + FileUtils.getRelativePath((File)file, (File)this.dir));
            try {
                this.updateCopyrightStatement(file);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot update file " + file.getName(), e);
            }
        }
        LOGGER.info("Done, updated " + files.size() + " files");
    }

    private List<File> findFiles(File dir) {
        try {
            return Files.walk(dir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> !file.isDirectory() && this.shouldUpdateCopyright((File)file)).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot walk directory " + dir, e);
        }
    }

    private boolean shouldUpdateCopyright(File file) {
        String ext = "." + FileUtils.getFileExtension((File)file);
        return SUPPORTED_FILE_EXTENSIONS.contains(ext) && !this.isExcludedDir(file);
    }

    private boolean isExcludedDir(File file) {
        for (String excludedDir : EXCLUDE_DIRS) {
            if (!file.getAbsolutePath().contains(excludedDir)) continue;
            return true;
        }
        return false;
    }

    private void updateCopyrightStatement(File file) throws IOException {
        List originalLines = FileUtils.readLines((File)file, (Charset)FILE_CHARSET);
        ArrayList<String> processedLines = new ArrayList<String>();
        for (String string : originalLines) {
            processedLines.add(this.processLine(string));
        }
        for (Tuple tuple : this.calculateDiff(originalLines, processedLines)) {
            LOGGER.info("    <<< " + ((String)tuple.getLeft()).trim());
            LOGGER.info("    >>> " + ((String)tuple.getRight()).trim());
        }
        PrintWriter writer = new PrintWriter(file, FILE_CHARSET.displayName());
        for (String line : processedLines) {
            writer.println(line);
        }
        writer.close();
    }

    protected String processLine(String line) {
        Matcher matcher = COPYRIGHT_PATTERN.matcher(line);
        if (!matcher.find()) {
            return this.processLineLicense(line);
        }
        if (matcher.group(3) == null) {
            return matcher.replaceFirst("Copyright " + this.newCopyrightYear);
        }
        if (this.startCopyrightYear.equals(LEAVE_MARKER)) {
            return matcher.replaceFirst("Copyright $1$2" + this.newCopyrightYear);
        }
        return matcher.replaceFirst("Copyright " + this.startCopyrightYear + "$2" + this.newCopyrightYear);
    }

    private String processLineLicense(String line) {
        if (this.license == null || LEAVE_MARKER.equals(this.license)) {
            return line;
        }
        if (!line.trim().toLowerCase().startsWith("// apache license")) {
            return line;
        }
        return "// " + this.license;
    }

    private List<Tuple<String, String>> calculateDiff(List<String> first, List<String> second) {
        Preconditions.checkArgument((first.size() == second.size() ? 1 : 0) != 0, (Object)"File should have the same length before/after");
        ArrayList<Tuple<String, String>> diff = new ArrayList<Tuple<String, String>>();
        for (int i = 0; i < first.size(); ++i) {
            if (first.get(i).equals(second.get(i))) continue;
            diff.add((Tuple<String, String>)Tuple.of((Object)first.get(i), (Object)second.get(i)));
        }
        return diff;
    }
}

