/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.tool;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.util.LogHelper;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.Utils2D;

public class ImageManipulationTool {
    protected File inputDir;
    protected File outputDir;
    protected String alphaChannel;
    protected int fade;
    private static final Color REAL_ALPHA = new Color(0, 0, 0, 0);
    private static final Logger LOGGER = LogHelper.getLogger(ImageManipulationTool.class);

    public static void main(String[] args) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser("ImageManipulationTool").add("--input", "Input directory containing the source images").add("--output", "Output directory for generated results").addOptional("--alpha", null, "Introduce alpha channel (color in the format #000000)");
        argParser.parseArgs(args);
        ImageManipulationTool tool = new ImageManipulationTool();
        tool.inputDir = argParser.getFile("input");
        tool.outputDir = argParser.getFile("output");
        tool.alphaChannel = argParser.get("alpha");
        tool.fade = argParser.getInt("fade");
        tool.run();
    }

    protected void run() {
        this.outputDir.mkdir();
        try {
            List imageFiles = Files.walk(this.inputDir.toPath(), new FileVisitOption[0]).map(path -> path.toFile()).filter(file -> this.isImageFile((File)file)).collect(Collectors.toList());
            for (File imageFile : imageFiles) {
                LOGGER.info("Converting image " + imageFile.getName());
                BufferedImage result = this.processImage(imageFile);
                File outputFile = new File(this.outputDir, imageFile.getName());
                Utils2D.savePNG((BufferedImage)result, (File)outputFile);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error while converting images", e);
        }
    }

    private boolean isImageFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        return file.getName().endsWith(".png") || file.getName().endsWith(".jpg");
    }

    private BufferedImage processImage(File file) throws IOException {
        BufferedImage image = Utils2D.loadImage((File)file);
        if (this.alphaChannel != null) {
            image = this.introduceAlphaChannel(image);
        }
        return image;
    }

    private BufferedImage introduceAlphaChannel(BufferedImage original) {
        BufferedImage result = new BufferedImage(original.getWidth(), original.getHeight(), 2);
        Color alphaChannelColor = Utils2D.parseHexColor((String)this.alphaChannel);
        for (int x = 0; x < original.getWidth(); ++x) {
            for (int y = 0; y < original.getHeight(); ++y) {
                int rgb = original.getRGB(x, y);
                if (rgb == alphaChannelColor.getRGB()) {
                    rgb = REAL_ALPHA.getRGB();
                }
                result.setRGB(x, y, rgb);
            }
        }
        return result;
    }
}

