/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import nl.colorize.multimedialib.demo.Demo2D;
import nl.colorize.multimedialib.demo.Demo3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;

public class DemoLauncher
implements ApplicationMenuListener {
    private String rendererName;
    private String graphics;
    private int framerate;
    private boolean canvasZoom;

    public static void main(String[] argv) {
        CommandLineArgumentParser args = new CommandLineArgumentParser(DemoLauncher.class).addOptional("--renderer", "Either 'java2d' or 'gdx'").addOptional("--graphics", "Either '2d' or '3d'").addOptional("--framerate", "Demo framerate, default is 60 fps").addFlag("--canvas", "Uses a fixed canvas size to display graphics").parseArgs(argv);
        DemoLauncher demo = new DemoLauncher();
        demo.rendererName = args.get("renderer").getStringOr("java2d");
        demo.graphics = args.get("graphics").getStringOr("2d");
        demo.framerate = args.get("framerate").getIntOr(60);
        demo.canvasZoom = args.get("canvas").getBool();
        demo.start();
    }

    private void start() {
        Canvas canvas = this.initCanvas();
        DisplayMode displayMode = new DisplayMode(canvas, this.framerate);
        WindowOptions window = new WindowOptions("MultimediaLib - Demo", WindowOptions.DEFAULT_ICON, this);
        Renderer renderer = switch (this.rendererName) {
            case "java2d" -> new Java2DRenderer(displayMode, window);
            case "libgdx", "gdx" -> new GDXRenderer(this.getGraphicsMode(), displayMode, window);
            default -> throw new UnsupportedOperationException("Unsupported renderer: " + this.rendererName);
        };
        Scene demo = this.createDemoScene();
        renderer.start(demo, (ErrorHandler)((Object)demo));
    }

    private Canvas initCanvas() {
        if (this.canvasZoom) {
            return Canvas.forSize(800, 600);
        }
        return Canvas.forNative(800, 600);
    }

    private GraphicsMode getGraphicsMode() {
        return switch (this.graphics) {
            case "2d" -> GraphicsMode.MODE_2D;
            case "3d" -> GraphicsMode.MODE_3D;
            default -> throw new UnsupportedOperationException("Unknown graphics mode: " + this.graphics);
        };
    }

    private Scene createDemoScene() {
        return switch (this.graphics) {
            case "2d" -> new Demo2D();
            case "3d" -> new Demo3D();
            default -> throw new UnsupportedOperationException("Unknown graphics mode: " + this.graphics);
        };
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }

    public boolean hasPreferencesMenu() {
        return false;
    }

    public void onPreferences() {
    }
}

