/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import nl.colorize.multimedialib.demo.Demo2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.pixi.PixiGraphics;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.HtmlCanvasGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaRenderer;
import nl.colorize.multimedialib.renderer.three.ThreeGraphics;
import nl.colorize.multimedialib.scene.SceneContext;

public class TeaDemo2D {
    private static final int BROWSER_FRAMERATE = 60;

    public static void main(String[] args) {
        Browser.log("MultimediaLib - TeaVM Demo");
        Browser.log("Screen size: " + Browser.getScreenWidth() + "x" + Browser.getScreenHeight());
        Browser.log("Page size: " + Math.round(Browser.getPageWidth()) + "x" + Math.round(Browser.getPageHeight()));
        Canvas canvas = Canvas.forSize(800, 600);
        DisplayMode displayMode = new DisplayMode(canvas, 60);
        TeaRenderer renderer = new TeaRenderer(displayMode, TeaDemo2D.initGraphics(canvas));
        renderer.start(new Demo2D(), TeaDemo2D::logError);
    }

    private static TeaGraphics initGraphics(Canvas canvas) {
        if (Browser.getPageQueryString().contains("pixi")) {
            return new PixiGraphics(canvas);
        }
        if (Browser.getPageQueryString().contains("three")) {
            return new ThreeGraphics(canvas);
        }
        return new HtmlCanvasGraphics(canvas);
    }

    private static void logError(SceneContext context, Exception cause) {
        Browser.log("----");
        Browser.log(cause.getMessage());
        Browser.log("----");
    }
}

