/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import nl.colorize.multimedialib.math.MathUtils;

public class RingBuffer {
    private LinkedList<Float> values;
    private int capacity;

    public RingBuffer(int capacity) {
        Preconditions.checkArgument((capacity >= 1 ? 1 : 0) != 0, (Object)("Invalid capacity: " + capacity));
        this.values = new LinkedList();
        this.capacity = capacity;
    }

    public void add(float value) {
        if (this.values.size() >= this.capacity) {
            this.values.removeFirst();
        }
        this.values.add(Float.valueOf(value));
    }

    public float getLatestValue() {
        return this.values.isEmpty() ? 0.0f : this.values.getLast().floatValue();
    }

    public float getAverageValue() {
        return MathUtils.average(this.values);
    }
}

