/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;

public class Canvas {
    private int preferredWidth;
    private int preferredHeight;
    private boolean zoom;
    private int screenWidth;
    private int screenHeight;
    private int offsetX;
    private int offsetY;

    private Canvas(int preferredWidth, int preferredHeight, boolean zoom) {
        this.resize(preferredWidth, preferredHeight);
        this.zoom = zoom;
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        Preconditions.checkArgument((screenWidth > 0 && screenHeight > 0 ? 1 : 0) != 0, (Object)("Invalid screen dimensions: " + screenWidth + "x" + screenHeight));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)this.screenWidth / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)this.screenHeight / this.getZoomLevel());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public Point2D getCenter() {
        return new Point2D((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public float getZoomLevel() {
        if (!this.zoom) {
            return 1.0f;
        }
        float horizontalZoom = (float)this.screenWidth / (float)this.preferredWidth;
        float verticalZoom = (float)this.screenHeight / (float)this.preferredHeight;
        return Math.max(horizontalZoom, verticalZoom);
    }

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.offsetX) / this.getZoomLevel();
    }

    public float toCanvasX(Point2D point) {
        return this.toCanvasX(Math.round(point.getX()));
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.offsetY) / this.getZoomLevel();
    }

    public float toCanvasY(Point2D point) {
        return this.toCanvasY(Math.round(point.getY()));
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.offsetX;
    }

    public float toScreenX(Point2D point) {
        return this.toScreenX(point.getX());
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.offsetY;
    }

    public float toScreenY(Point2D point) {
        return this.toScreenY(point.getY());
    }

    @Deprecated
    public void changeStrategy(boolean zoom) {
        this.zoom = zoom;
    }

    @Deprecated
    public void resize(int preferredWidth, int preferredHeight) {
        Preconditions.checkArgument((preferredWidth > 0 && preferredHeight > 0 ? 1 : 0) != 0, (Object)("Invalid canvas dimensions: " + preferredWidth + "x" + preferredHeight));
        this.preferredWidth = preferredWidth;
        this.preferredHeight = preferredHeight;
    }

    public String toString() {
        float zoomLevel = this.getZoomLevel();
        return this.getWidth() + "x" + this.getHeight() + " @ " + MathUtils.format(zoomLevel, 1) + "x";
    }

    public static Canvas forSize(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight, true);
    }

    public static Canvas forNative(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight, false);
    }
}

