/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.LinkedHashMap;
import java.util.Map;
import nl.colorize.multimedialib.math.RingBuffer;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.Stopwatch;

public class FrameStats {
    private Stopwatch timer;
    private RingBuffer frameTime;
    private RingBuffer frameUpdateTime;
    private RingBuffer frameRenderTime;
    private int spriteCount;
    private int primitiveCount;
    private int textCount;
    private Map<String, RingBuffer> customStats;
    private static final int FRAME_STATISTICS_WINDOW = 60;

    public FrameStats() {
        this(new Stopwatch());
    }

    protected FrameStats(Stopwatch timer) {
        this.timer = timer;
        this.frameTime = new RingBuffer(60);
        this.frameUpdateTime = new RingBuffer(60);
        this.frameRenderTime = new RingBuffer(60);
        this.customStats = new LinkedHashMap<String, RingBuffer>();
    }

    public void markFrameStart() {
        this.frameTime.add(this.timer.tick());
    }

    public void markFrameUpdate() {
        this.frameUpdateTime.add(this.timer.tock());
    }

    public void markFrameRender() {
        this.frameRenderTime.add(Math.max((float)this.timer.tock() - this.frameUpdateTime.getLatestValue(), 0.0f));
    }

    public void markDrawOperation(Graphic2D graphic) {
        if (graphic instanceof Sprite) {
            ++this.spriteCount;
        } else if (graphic instanceof Primitive) {
            ++this.primitiveCount;
        } else if (graphic instanceof Text) {
            ++this.textCount;
        }
    }

    public void markCustom(String name, float time) {
        RingBuffer buffer = this.customStats.get(name);
        if (buffer == null) {
            buffer = new RingBuffer(60);
            this.customStats.put(name, buffer);
        }
        buffer.add(time);
    }

    public void markCustom(Object phase, float time) {
        this.markCustom(phase.getClass().getSimpleName(), time);
    }

    public void resetDrawOperations() {
        this.spriteCount = 0;
        this.primitiveCount = 0;
        this.textCount = 0;
    }

    public float getFrameTime() {
        return this.frameTime.getAverageValue();
    }

    public int getFramerate() {
        return Math.round(1.0f / (this.getFrameTime() / 1000.0f));
    }

    public int getFrameUpdateTime() {
        return Math.round(this.frameUpdateTime.getAverageValue());
    }

    public int getFrameRenderTime() {
        return Math.round(this.frameRenderTime.getAverageValue());
    }

    public int getSpriteCount() {
        return this.spriteCount;
    }

    public int getPrimitiveCount() {
        return this.primitiveCount;
    }

    public int getTextCount() {
        return this.textCount;
    }

    public Map<String, Integer> getCustomStats() {
        LinkedHashMap<String, Integer> averages = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, RingBuffer> entry : this.customStats.entrySet()) {
            averages.put(entry.getKey(), Math.round(entry.getValue().getAverageValue()));
        }
        return averages;
    }
}

