/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.scene.Updatable;

public class FrameSync {
    private DisplayMode displayMode;
    private long lastFrameTimestamp;
    private long elapsedTime;
    private static final int MAX_FRAMES = 2;
    private static final long LEEWAY_MS = 5L;

    public FrameSync(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.lastFrameTimestamp = 0L;
    }

    public void requestFrame(long timestamp, Updatable callback) {
        float targetFrameTime = this.displayMode.getFrameTime();
        long targetFrameTimeMS = this.displayMode.getFrameTimeMS();
        if (this.lastFrameTimestamp == 0L) {
            callback.update(targetFrameTime);
            this.lastFrameTimestamp = timestamp;
            return;
        }
        this.elapsedTime += timestamp - this.lastFrameTimestamp;
        this.lastFrameTimestamp = timestamp;
        if (this.elapsedTime >= targetFrameTimeMS - 5L) {
            float deltaTime = Math.min((float)this.elapsedTime / 1000.0f, targetFrameTime * 2.0f);
            callback.update(deltaTime);
            this.elapsedTime = 0L;
        }
    }
}

