/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Properties;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.SpriteAtlasLoader;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.Shader;
import nl.colorize.multimedialib.stage.SpriteAtlas;

public interface MediaLoader {
    public Image loadImage(FilePointer var1);

    default public SpriteAtlas loadAtlas(FilePointer file) {
        SpriteAtlasLoader atlasLoader = new SpriteAtlasLoader(this);
        return atlasLoader.load(file);
    }

    public Audio loadAudio(FilePointer var1);

    public OutlineFont loadFont(FilePointer var1, FontStyle var2);

    default public OutlineFont loadDefaultFont(int size, ColorRGB color) {
        FilePointer file = new FilePointer("OpenSans-Regular.ttf");
        FontStyle style = new FontStyle("Open Sans", size, false, color);
        return this.loadFont(file, style);
    }

    public PolygonModel loadModel(FilePointer var1);

    public GeometryBuilder getGeometryBuilder();

    public Shader loadShader(FilePointer var1, FilePointer var2);

    public String loadText(FilePointer var1);

    default public List<String> loadTextLines(FilePointer file) {
        return Splitter.on((String)"\n").splitToList((CharSequence)this.loadText(file));
    }

    public boolean containsResourceFile(FilePointer var1);

    public Properties loadApplicationData(String var1, String var2);

    public void saveApplicationData(Properties var1, String var2, String var3);
}

