/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.List;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.java2d.AWTFont;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Layer2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.stats.Cache;
import nl.colorize.util.swing.Utils2D;

public class Java2DGraphicsContext
implements StageVisitor {
    private Canvas canvas;
    private Graphics2D g2;
    private Cache<ColorRGB, Color> colorCache;
    private Cache<MaskImage, BufferedImage> maskCache;
    private Cache<CircleImage, BufferedImage> circleCache;
    private static final Transform NULL_TRANSFORM = new Transform();
    private static final int CACHE_CAPACITY = 1000;

    public Java2DGraphicsContext(Canvas canvas) {
        this.canvas = canvas;
        this.colorCache = Cache.from(this::convertColor, (int)1000);
        this.maskCache = Cache.from(MaskImage::render, (int)1000);
        this.circleCache = Cache.from(CircleImage::render, (int)1000);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void bind(Graphics2D g2) {
        this.g2 = g2;
    }

    public void dispose() {
        if (this.g2 != null) {
            this.g2.dispose();
            this.g2 = null;
        }
    }

    public void clear(int windowWidth, int windowHeight) {
        this.g2.setColor(Color.BLACK);
        this.g2.fillRect(0, 0, windowWidth, windowHeight);
    }

    @Override
    public void prepareLayer(Layer2D layer) {
    }

    @Override
    public void drawBackground(ColorRGB backgroundColor) {
        float width = this.canvas.toScreenX(this.canvas.getWidth());
        float height = this.canvas.toScreenY(this.canvas.getHeight());
        this.g2.setColor((Color)this.colorCache.get((Object)backgroundColor));
        this.g2.fillRect(0, 0, Math.round(width), Math.round(height) + 30);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        float x0 = this.canvas.toScreenX(line.getStart().getX());
        float y0 = this.canvas.toScreenY(line.getStart().getY());
        float x1 = this.canvas.toScreenX(line.getEnd().getX());
        float y1 = this.canvas.toScreenY(line.getEnd().getY());
        this.g2.setStroke(new BasicStroke(line.getThickness()));
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        this.g2.drawLine(Math.round(x0), Math.round(y0), Math.round(x1), Math.round(y1));
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        float screenX = this.canvas.toScreenX(rect.getX());
        float screenY = this.canvas.toScreenY(rect.getY());
        float screenWidth = this.canvas.toScreenX(rect.getEndX()) - screenX;
        float screenHeight = this.canvas.toScreenY(rect.getEndY()) - screenY;
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(graphic.getAlpha());
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        this.g2.fillRect(Math.round(screenX), Math.round(screenY), Math.round(screenWidth), Math.round(screenHeight));
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        CircleImage key = new CircleImage(circle.getRadius(), (Color)this.colorCache.get((Object)graphic.getColor()));
        BufferedImage image = (BufferedImage)this.circleCache.get((Object)key);
        Transform transform = new Transform();
        transform.setAlpha(graphic.getAlpha());
        this.drawImage(image, circle.getCenter(), transform);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        int[] px = new int[polygon.getNumPoints()];
        int[] py = new int[polygon.getNumPoints()];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            px[i] = Math.round(this.canvas.toScreenX(polygon.getPointX(i)));
            py[i] = Math.round(this.canvas.toScreenY(polygon.getPointY(i)));
        }
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(graphic.getAlpha());
        this.g2.setColor((Color)this.colorCache.get((Object)graphic.getColor()));
        this.g2.fillPolygon(px, py, polygon.getNumPoints());
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawSprite(Sprite sprite) {
        BufferedImage image = ((AWTImage)sprite.getCurrentGraphics()).getImage();
        this.drawImage(image, sprite.getPosition(), sprite.getTransform());
    }

    private void drawImage(BufferedImage image, Point2D position, Transform transform) {
        if (transform == null) {
            transform = NULL_TRANSFORM;
        }
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(transform.getAlpha());
        AffineTransform transform2D = this.applyTransform(position, image.getWidth(), image.getHeight(), transform);
        this.g2.drawImage(image, transform2D, null);
        if (transform.getMask() != null) {
            MaskImage key = new MaskImage(image, (Color)this.colorCache.get((Object)transform.getMask()));
            this.g2.drawImage((Image)this.maskCache.get((Object)key), transform2D, null);
        }
        this.g2.setComposite(originalComposite);
    }

    @Override
    public void drawText(Text text) {
        Font font = ((AWTFont)text.getFont().scale(this.canvas)).getFont();
        FontStyle style = text.getFont().getStyle();
        Composite originalComposite = this.g2.getComposite();
        this.applyAlphaComposite(text.getAlpha());
        this.g2.setColor((Color)this.colorCache.get((Object)style.color()));
        this.g2.setFont(font);
        this.drawLines(text.getLines(), text.getPosition(), text.getAlign(), text.getLineHeight());
        this.g2.setComposite(originalComposite);
    }

    private void drawLines(List<String> lines, Point2D position, Align align, float lineHeight) {
        for (int i = 0; i < lines.size(); ++i) {
            float screenX = this.canvas.toScreenX(position.getX());
            float screenY = this.canvas.toScreenY(position.getY() + (float)i * lineHeight);
            int estimatedWidth = this.g2.getFontMetrics().stringWidth(lines.get(i));
            if (align == Align.CENTER) {
                this.g2.drawString(lines.get(i), screenX - (float)estimatedWidth / 2.0f, screenY);
                continue;
            }
            if (align == Align.RIGHT) {
                this.g2.drawString(lines.get(i), screenX - (float)estimatedWidth, screenY);
                continue;
            }
            this.g2.drawString(lines.get(i), screenX, screenY);
        }
    }

    private AffineTransform applyTransform(Point2D position, int width, int height, Transform transform) {
        float screenX = this.canvas.toScreenX(position.getX());
        float screenY = this.canvas.toScreenY(position.getY());
        float scaleX = this.canvas.getZoomLevel() * (transform.getScaleX() / 100.0f);
        float scaleY = this.canvas.getZoomLevel() * (transform.getScaleY() / 100.0f);
        int screenWidth = (int)((float)width * scaleX);
        int screenHeight = (int)((float)height * scaleY);
        AffineTransform transform2D = new AffineTransform();
        transform2D.setToIdentity();
        transform2D.translate(screenX - (float)screenWidth / 2.0f, screenY - (float)screenHeight / 2.0f);
        transform2D.rotate(transform.getRotationInRadians(), (double)screenWidth / 2.0, (double)screenHeight / 2.0);
        transform2D.scale(scaleX, scaleY);
        return transform2D;
    }

    private void applyAlphaComposite(float alpha) {
        if (alpha != 100.0f) {
            AlphaComposite alphaComposite = AlphaComposite.SrcOver.derive(alpha / 100.0f);
            this.g2.setComposite(alphaComposite);
        }
    }

    private Color convertColor(ColorRGB color) {
        return new Color(color.r(), color.g(), color.b());
    }

    private record CircleImage(float radius, Color color) {
        public BufferedImage render() {
            int size = Math.round(this.radius * 2.0f);
            BufferedImage image = new BufferedImage(size, size, 2);
            Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)false);
            g2.setColor(this.color);
            g2.fillOval(0, 0, size, size);
            g2.dispose();
            return image;
        }
    }

    private record MaskImage(BufferedImage original, Color maskColor) {
        public BufferedImage render() {
            BufferedImage image = new BufferedImage(this.original.getWidth(), this.original.getHeight(), 2);
            Graphics2D g2 = Utils2D.createGraphics((BufferedImage)image, (boolean)true, (boolean)false);
            g2.setComposite(AlphaComposite.Clear);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.setComposite(AlphaComposite.SrcOver);
            g2.setColor(this.maskColor);
            g2.drawImage(this.original, 0, 0, this.original.getWidth(), this.original.getHeight(), null);
            g2.setComposite(AlphaComposite.SrcAtop);
            g2.fillRect(0, 0, image.getWidth(), image.getHeight());
            g2.dispose();
            return image;
        }
    }
}

