/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.Player;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.util.LogHelper;
import nl.colorize.util.ResourceFile;

public class MP3
extends Audio {
    private ResourceFile audioClip;
    private static final Logger LOGGER = LogHelper.getLogger(MP3.class);

    public MP3(ResourceFile audioClip) {
        this.audioClip = audioClip;
    }

    @Override
    public void play() {
        Thread audioThread = new Thread(this::playAudioClip, "MultimediaLib-Audio");
        audioThread.start();
    }

    private void playAudioClip() {
        try (InputStream audioStream = this.audioClip.openStream();){
            Player player = new Player(audioStream);
            player.play();
            if (this.isLoop()) {
                this.playAudioClip();
            }
        }
        catch (IOException | JavaLayerException e) {
            LOGGER.log(Level.WARNING, "Error during playback of " + this.audioClip, e);
        }
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
    }
}

