/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.OutlineFont;

public class GDXBitmapFont
implements OutlineFont {
    private GDXMediaLoader fontLoader;
    private FileHandle source;
    private FontStyle style;
    private BitmapFont bitmapFont;

    protected GDXBitmapFont(GDXMediaLoader fontLoader, FileHandle source, FontStyle style) {
        this.fontLoader = fontLoader;
        this.source = source;
        this.style = style;
        this.bitmapFont = fontLoader.getBitmapFont(source, style);
    }

    protected BitmapFont getBitmapFont() {
        return this.bitmapFont;
    }

    @Override
    public FontStyle getStyle() {
        return this.style;
    }

    @Override
    public OutlineFont derive(FontStyle newStyle) {
        Preconditions.checkArgument((boolean)this.style.family().equals(newStyle.family()), (Object)("Font family mismatch: expected " + this.style.family()));
        return new GDXBitmapFont(this.fontLoader, this.source, newStyle);
    }
}

