/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;

public class GDXImage
implements Image {
    private FilePointer origin;
    private Texture texture;
    private TextureRegion textureRegion;
    private Pixmap textureData;
    private Region bounds;

    protected GDXImage(FilePointer origin, Texture texture, Region bounds) {
        float u1 = (float)bounds.x() / (float)texture.getWidth();
        float v1 = (float)bounds.y() / (float)texture.getHeight();
        float u2 = (float)bounds.x1() / (float)texture.getWidth();
        float v2 = (float)bounds.y1() / (float)texture.getHeight();
        this.origin = origin;
        this.texture = texture;
        this.textureRegion = new TextureRegion(texture, u1, v1, u2, v2);
        this.bounds = bounds;
    }

    protected GDXImage(FilePointer origin, Texture texture) {
        this(origin, texture, new Region(0, 0, texture.getWidth(), texture.getHeight()));
    }

    protected TextureRegion getTextureRegion() {
        return this.textureRegion;
    }

    @Override
    public Region getRegion() {
        return this.bounds;
    }

    @Override
    public Image extractRegion(Region region) {
        return new GDXImage(this.origin, this.texture, region);
    }

    private void loadTextureData() {
        if (this.textureData == null) {
            TextureData data = this.texture.getTextureData();
            data.prepare();
            this.textureData = data.consumePixmap();
        }
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        return new ColorRGB(rgba);
    }

    @Override
    public int getAlpha(int x, int y) {
        this.loadTextureData();
        int rgba = this.textureData.getPixel(x, y);
        int alpha = rgba >> 24 & 0xFF;
        return Math.round((float)alpha / 2.55f);
    }
}

