/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Files;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3ApplicationConfiguration;
import com.badlogic.gdx.graphics.glutils.HdpiMode;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RenderCapabilities;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.StandardNetwork;
import nl.colorize.multimedialib.renderer.libgdx.GDXGraphics;
import nl.colorize.multimedialib.renderer.libgdx.GDXInput;
import nl.colorize.multimedialib.renderer.libgdx.GDXMediaLoader;
import nl.colorize.multimedialib.scene.RenderContext;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.util.LogHelper;

public class GDXRenderer
implements Renderer,
ApplicationListener {
    private GraphicsMode graphicsMode;
    private Canvas canvas;
    private int framerate;
    private WindowOptions window;
    private GDXInput input;
    private GDXMediaLoader mediaLoader;
    private SceneContext context;
    private Scene initialScene;
    private GDXGraphics graphicsContext;
    private static final Logger LOGGER = LogHelper.getLogger(GDXRenderer.class);

    public GDXRenderer(GraphicsMode graphicsMode, DisplayMode displayMode, WindowOptions window) {
        this.graphicsMode = graphicsMode;
        this.canvas = displayMode.canvas();
        this.framerate = displayMode.framerate();
        this.window = window;
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.initialScene = initialScene;
        Lwjgl3ApplicationConfiguration config = new Lwjgl3ApplicationConfiguration();
        config.setWindowedMode(this.canvas.getWidth(), this.canvas.getHeight());
        config.setDecorated(true);
        config.setIdleFPS(this.framerate);
        config.setForegroundFPS(this.framerate);
        config.setHdpiMode(HdpiMode.Pixels);
        config.setTitle(this.window.title());
        if (this.window.iconFile() != null) {
            config.setWindowIcon(Files.FileType.Internal, new String[]{this.window.iconFile().path()});
        }
        try {
            new Lwjgl3Application((ApplicationListener)this, config);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error during animation loop", e);
            errorHandler.onError(this.context, e);
        }
    }

    public void create() {
        this.mediaLoader = new GDXMediaLoader();
        this.input = new GDXInput(this.canvas);
        this.resize(this.canvas.getWidth(), this.canvas.getHeight());
        this.graphicsContext = new GDXGraphics(this.canvas);
        this.context = new RenderContext(this);
        this.context.changeScene(this.initialScene);
    }

    public void dispose() {
        this.graphicsContext.dispose();
        this.mediaLoader.dispose();
    }

    public void resize(int width, int height) {
        this.canvas.resizeScreen(width, height);
    }

    public void pause() {
    }

    public void resume() {
    }

    public void render() {
        this.context.getFrameStats().markFrameStart();
        Gdx.gl.glViewport(0, 0, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16640);
        float frameTime = 1.0f / (float)this.framerate;
        this.input.update(frameTime);
        this.context.update(frameTime);
        this.context.getFrameStats().markFrameUpdate();
        this.renderStage(this.context.getStage());
        this.graphicsContext.switchMode(false, false);
        this.context.getFrameStats().markFrameRender();
    }

    private void renderStage(Stage stage) {
        if (this.graphicsMode == GraphicsMode.MODE_3D) {
            this.graphicsContext.render3D(stage.getLayer3D());
        }
        stage.visit(this.graphicsContext);
    }

    @Override
    public RenderCapabilities getCapabilities() {
        DisplayMode displayMode = new DisplayMode(this.canvas, this.framerate);
        StandardNetwork network = new StandardNetwork();
        return new RenderCapabilities(this.graphicsMode, displayMode, this.graphicsContext, this.input, this.mediaLoader, network);
    }
}

