/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import java.util.Optional;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Promise;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.typedarrays.Uint8ClampedArray;

public class TeaImage
implements Image {
    private Promise<HTMLImageElement> imgPromise;
    private Region region;
    private CanvasRenderingContext2D imageData;
    private static final Region IMAGE_LOADING_REGION = new Region(0, 0, 1, 1);
    private static final Logger LOGGER = LogHelper.getLogger(TeaImage.class);

    protected TeaImage(Promise<HTMLImageElement> imgPromise, Region region) {
        this.imgPromise = imgPromise;
        this.region = region;
    }

    public Promise<HTMLImageElement> getImagePromise() {
        return this.imgPromise;
    }

    public Optional<HTMLImageElement> getImageElement() {
        return this.imgPromise.getValue();
    }

    public boolean isLoaded() {
        return this.imgPromise.getValue().isPresent();
    }

    @Override
    public Region getRegion() {
        if (this.region != null) {
            return this.region;
        }
        return this.imgPromise.getValue().map(img -> new Region(0, 0, img.getWidth(), img.getHeight())).orElse(IMAGE_LOADING_REGION);
    }

    @Override
    public TeaImage extractRegion(Region region) {
        return new TeaImage(this.imgPromise, region);
    }

    @Override
    public ColorRGB getColor(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return new ColorRGB(rgba[0], rgba[1], rgba[2]);
    }

    @Override
    public int getAlpha(int x, int y) {
        int[] rgba = this.getImageData(x, y);
        return Math.round((float)rgba[3] / 2.55f);
    }

    private int[] getImageData(int x, int y) {
        HTMLImageElement img = this.imgPromise.getValue().orElse(null);
        if (img == null) {
            return new int[]{0, 0, 0, 0};
        }
        if (this.imageData == null) {
            HTMLDocument document = Window.current().getDocument();
            HTMLCanvasElement canvas = (HTMLCanvasElement)document.createElement("canvas");
            this.imageData = (CanvasRenderingContext2D)canvas.getContext("2d");
            this.imageData.drawImage((CanvasImageSource)img, 0.0, 0.0);
        }
        Uint8ClampedArray rgba = this.imageData.getImageData((double)x, (double)y, 1.0, 1.0).getData();
        return new int[]{rgba.get(0), rgba.get(1), rgba.get(2), rgba.get(3)};
    }

    public String toString() {
        return this.imgPromise.getValue().map(HTMLImageElement::getSrc).orElse("<loading>");
    }
}

