/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.FrameSync;
import nl.colorize.multimedialib.renderer.RenderCapabilities;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaInputDevice;
import nl.colorize.multimedialib.renderer.teavm.TeaMediaLoader;
import nl.colorize.multimedialib.renderer.teavm.TeaNetwork;
import nl.colorize.multimedialib.scene.RenderContext;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.StageObserver;
import org.teavm.jso.browser.Window;

public class TeaRenderer
implements Renderer {
    private DisplayMode displayMode;
    private TeaGraphics graphics;
    private TeaInputDevice inputDevice;
    private TeaMediaLoader mediaLoader;
    private SceneContext context;
    private FrameSync frameSync;

    public TeaRenderer(DisplayMode displayMode, TeaGraphics graphics) {
        this.displayMode = displayMode;
        this.graphics = graphics;
        this.mediaLoader = new TeaMediaLoader(graphics);
        this.inputDevice = new TeaInputDevice(displayMode.canvas(), graphics);
        this.frameSync = new FrameSync(displayMode);
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        this.context = new RenderContext(this);
        this.context.changeScene(initialScene);
        this.graphics.init();
        TeaGraphics teaGraphics = this.graphics;
        if (teaGraphics instanceof StageObserver) {
            StageObserver observer = (StageObserver)((Object)teaGraphics);
            this.context.getStage().getObservers().add(observer);
        }
        this.inputDevice.bindEventHandlers();
        Browser.prepareAnimationLoop();
        Browser.registerErrorHandler(error -> this.handleError(errorHandler, error));
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private void onAnimationFrame(double timestamp) {
        if (this.prepareCanvas()) {
            this.frameSync.requestFrame((long)timestamp, deltaTime -> {
                this.context.getFrameStats().markFrameStart();
                this.context.update(deltaTime);
                this.context.getFrameStats().markFrameUpdate();
                this.context.getStage().visit(this.graphics);
                this.context.getFrameStats().markFrameRender();
                this.inputDevice.reset();
            });
        }
        Window.requestAnimationFrame(this::onAnimationFrame);
    }

    private boolean prepareCanvas() {
        int width = this.graphics.getDisplayWidth();
        int height = this.graphics.getDisplayHeight();
        if (width > 0 || height > 0) {
            this.displayMode.canvas().resizeScreen(width, height);
            return true;
        }
        return false;
    }

    @Override
    public RenderCapabilities getCapabilities() {
        TeaNetwork network = new TeaNetwork();
        return new RenderCapabilities(this.graphics.getGraphicsMode(), this.displayMode, this.graphics, this.inputDevice, this.mediaLoader, network);
    }

    private void handleError(ErrorHandler errorHandler, String error) {
        RuntimeException cause = new RuntimeException("JavaScript error\n\n" + error);
        errorHandler.onError(this.context, cause);
    }
}

