/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.RenderCapabilities;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.util.Platform;

public class RenderContext
implements SceneContext {
    private RenderCapabilities renderCapabilities;
    private Stage stage;
    private SceneGraph activeSceneGraph;
    private SceneGraph requestedSceneGraph;
    private List<Scene> globalScenes;
    private FrameStats frameStats;

    public RenderContext(Renderer renderer) {
        this.renderCapabilities = renderer.getCapabilities();
        this.globalScenes = new ArrayList<Scene>();
        this.frameStats = new FrameStats();
        GraphicsMode graphicsMode = this.renderCapabilities.graphicsMode();
        Canvas canvas = this.renderCapabilities.getCanvas();
        this.stage = new Stage(graphicsMode, canvas, this.frameStats);
    }

    @Override
    public void update(float deltaTime) {
        this.stage.update(deltaTime);
        if (this.requestedSceneGraph != null) {
            this.activateRequestedScene();
        }
        this.updateSceneGraph(this.activeSceneGraph, deltaTime);
        this.updateGlobalScenes(deltaTime);
    }

    private void updateSceneGraph(SceneGraph current, float deltaTime) {
        current.scene.update(this, deltaTime);
        for (int i = current.subScenes.size() - 1; i >= 0; --i) {
            SceneGraph subScene = current.subScenes.get(i);
            if (this.checkCompleted(current, subScene)) continue;
            this.updateSceneGraph(subScene, deltaTime);
            this.checkCompleted(current, subScene);
        }
    }

    private boolean checkCompleted(SceneGraph parent, SceneGraph subScene) {
        if (subScene.scene.isCompleted()) {
            subScene.scene.end(this);
            parent.subScenes.remove(subScene);
            return true;
        }
        return false;
    }

    private void activateRequestedScene() {
        if (this.activeSceneGraph != null) {
            this.activeSceneGraph.walk(scene -> scene.end(this));
            this.stage.clear();
        }
        this.activeSceneGraph = this.requestedSceneGraph;
        this.activeSceneGraph.walk(scene -> scene.start(this));
        this.requestedSceneGraph = null;
    }

    private void updateGlobalScenes(float deltaTime) {
        Iterator<Scene> iterator = this.globalScenes.iterator();
        while (iterator.hasNext()) {
            Scene globalScene = iterator.next();
            globalScene.update(this, deltaTime);
            if (!globalScene.isCompleted()) continue;
            iterator.remove();
        }
    }

    @Override
    public void changeScene(Scene requestedScene) {
        this.requestedSceneGraph = new SceneGraph(requestedScene);
    }

    @Override
    public void attach(Scene subScene) {
        SceneGraph subSceneGraph = new SceneGraph(subScene);
        if (this.requestedSceneGraph == null) {
            this.activeSceneGraph.subScenes.add(0, subSceneGraph);
            subScene.start(this);
        } else {
            this.requestedSceneGraph.subScenes.add(0, subSceneGraph);
        }
    }

    @Override
    public void attach(Updatable subScene) {
        this.attach(Scene.wrap(subScene));
    }

    @Override
    public void attachGlobalScene(Scene globalScene) {
        this.globalScenes.add(globalScene);
        globalScene.start(this);
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public String getRendererName() {
        return this.renderCapabilities.graphics().getClass().getSimpleName().replace("GraphicsContext", "").replace("Graphics", "");
    }

    @Override
    public RenderCapabilities getRenderCapabilities() {
        return this.renderCapabilities;
    }

    @Override
    public FrameStats getFrameStats() {
        return this.frameStats;
    }

    @Override
    public boolean quit() {
        boolean success = false;
        if (Platform.isWindows() || Platform.isMac()) {
            success = true;
            System.exit(0);
        }
        return success;
    }

    @Override
    public List<String> getDebugInformation() {
        int targetFPS = this.getDisplayMode().framerate();
        ArrayList<String> info = new ArrayList<String>();
        info.add("Renderer:  " + this.getRendererName());
        info.add("Canvas:  " + this.getCanvas());
        info.add("Framerate:  " + this.frameStats.getFramerate() + " / " + targetFPS);
        info.add("Update time:  " + this.frameStats.getFrameUpdateTime() + "ms");
        info.add("Render time:  " + this.frameStats.getFrameRenderTime() + "ms");
        info.add("# Sprites:  " + this.frameStats.getSpriteCount());
        info.add("# Primitives:  " + this.frameStats.getPrimitiveCount());
        info.add("# Text:  " + this.frameStats.getTextCount());
        return info;
    }

    private record SceneGraph(Scene scene, List<SceneGraph> subScenes) {
        public SceneGraph(Scene scene) {
            this(scene, new ArrayList<SceneGraph>());
        }

        public void walk(Consumer<Scene> callback) {
            callback.accept(this.scene);
            this.subScenes.forEach(subScene -> subScene.walk(callback));
        }
    }
}

