/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Layer2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.animation.Timeline;

public class WipeTransition
extends Effect {
    private Timeline timeline;
    private boolean reverse;
    private Image particleImage;
    private float duration;
    private ColorRGB fillColor;
    private List<List<Particle>> particles;
    public static final FilePointer DIAMOND = new FilePointer("effects/particle-diamond.png");
    public static final FilePointer CIRCLE = new FilePointer("effects/particle-circle.png");
    private static final String LAYER = "$$WipeTransition";
    private static final int PARTICLE_SIZE = 64;

    public WipeTransition(FilePointer imageFile, ColorRGB color, float duration, boolean reverse) {
        this.timeline = new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(duration, 1.0f);
        this.duration = duration;
        this.fillColor = color;
        this.reverse = reverse;
        this.particles = new ArrayList<List<Particle>>();
        this.addStartHandler(() -> this.initialize(imageFile));
        this.addFrameHandler(arg_0 -> ((Timeline)this.timeline).movePlayhead(arg_0));
        this.addFrameHandler(this::updateParticles);
        this.addFrameHandler(this::updateFill);
        this.stopIf(() -> ((Timeline)this.timeline).isCompleted());
    }

    public WipeTransition(ColorRGB color, float duration, boolean reverse) {
        this(DIAMOND, color, duration, reverse);
    }

    private void initialize(FilePointer imageFile) {
        SceneContext context = this.getContext();
        this.particleImage = context.getMediaLoader().loadImage(imageFile);
        this.generateParticles(context.getCanvas());
        this.particles.stream().flatMap(column -> column.stream()).forEach(particle -> this.addParticleSprite(context, particle.sprite));
    }

    private void generateParticles(Canvas canvas) {
        this.particles.clear();
        for (int x = 0; x <= canvas.getWidth(); x += 64) {
            ArrayList<Particle> column = new ArrayList<Particle>();
            this.particles.add(column);
            for (int y = 0; y <= canvas.getHeight(); y += 64) {
                float pDelay = (float)(column.size() + 1) * 0.04f;
                Particle particle = new Particle(x, y, pDelay, this.duration * 0.5f);
                particle.sprite = new Sprite(this.particleImage);
                column.add(particle);
            }
        }
    }

    private void addParticleSprite(SceneContext context, Sprite sprite) {
        Layer2D layer = context.getStage().retrieveLayer(LAYER);
        layer.add(sprite);
        this.removeAfterwards(sprite);
    }

    private void updateParticles(float deltaTime) {
        for (List<Particle> column : this.particles) {
            for (Particle particle : column) {
                particle.timeline.movePlayhead(deltaTime);
                particle.sprite.setPosition(particle.position);
                particle.sprite.setTransform(this.getParticleTransform(particle));
            }
        }
    }

    private void updateFill(float deltaTime) {
        if (!this.reverse && this.fillColor != null && this.timeline.getDelta() >= 0.8f) {
            Primitive fill = Primitive.of(this.getContext().getCanvas().getBounds(), this.fillColor);
            this.getContext().getStage().retrieveLayer(LAYER).add(fill);
            this.removeAfterwards(fill);
        }
    }

    private Transform getParticleTransform(Particle particle) {
        float delta = particle.timeline.getValue();
        if (this.reverse) {
            delta = 1.0f - delta;
        }
        Transform transform = new Transform();
        transform.setScale(Math.max(delta * 200.0f, 1.0f));
        transform.setMask(this.fillColor);
        return transform;
    }

    private static class Particle {
        private Point2D position;
        private Timeline timeline;
        private Sprite sprite;

        public Particle(float x, float y, float delay, float duration) {
            this.position = new Point2D(x, y);
            this.timeline = new Timeline().addKeyFrame(0.0f, 0.0f).addKeyFrame(delay, 0.0f).addKeyFrame(delay + duration, 1.0f);
        }
    }
}

