/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.StageObserver;

public class Layer2D
implements Updatable {
    private String name;
    private List<Graphic2D> graphics;
    private List<StageObserver> observers;
    public static final String DEFAULT_LAYER = "$$default";

    protected Layer2D(String name, List<StageObserver> observers) {
        this.name = name;
        this.graphics = new ArrayList<Graphic2D>();
        this.observers = observers;
        observers.forEach(observer -> observer.onLayerAdded(this));
    }

    public String getName() {
        return this.name;
    }

    public void add(Graphic2D ... contents) {
        for (Graphic2D graphic : contents) {
            this.graphics.add(graphic);
            this.observers.forEach(observer -> observer.onGraphicAdded(this, graphic));
        }
    }

    public void add(Group group) {
        for (Graphic2D graphic : group) {
            this.add(graphic);
        }
    }

    public void remove(Graphic2D graphic) {
        this.graphics.remove(graphic);
        this.observers.forEach(observer -> observer.onGraphicRemoved(this, graphic));
    }

    public void remove(Group group) {
        for (Graphic2D graphic : group) {
            this.remove(graphic);
        }
    }

    public Iterable<Graphic2D> getGraphics() {
        return this.graphics;
    }

    @Override
    public void update(float deltaTime) {
        for (Graphic2D graphic : this.graphics) {
            graphic.update(deltaTime);
        }
    }

    public String toString() {
        return this.name;
    }
}

