/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Point3D;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.StageObserver;

public class Layer3D
implements Updatable {
    private Point3D cameraPosition;
    private Point3D cameraTarget;
    private ColorRGB ambientLight;
    private ColorRGB lightColor;
    private Point3D lightPosition;
    private List<PolygonModel> models = new ArrayList<PolygonModel>();
    private List<StageObserver> observers;

    protected Layer3D(List<StageObserver> observers) {
        this.observers = observers;
        this.clear();
    }

    public void clear() {
        this.cameraPosition = new Point3D(10.0f, 10.0f, 10.0f);
        this.cameraTarget = new Point3D(0.0f, 0.0f, 0.0f);
        this.ambientLight = new ColorRGB(100, 100, 100);
        this.lightColor = new ColorRGB(200, 200, 200);
        this.lightPosition = new Point3D(-1.0f, -0.8f, -0.2f);
        this.models.clear();
    }

    public void moveCamera(Point3D position, Point3D target) {
        this.cameraPosition = position;
        this.cameraTarget = target;
    }

    public Point3D getCameraPosition() {
        return this.cameraPosition;
    }

    public Point3D getCameraTarget() {
        return this.cameraTarget;
    }

    public void changeAmbientLight(ColorRGB color) {
        this.ambientLight = color;
    }

    public ColorRGB getAmbientLight() {
        return this.ambientLight;
    }

    public void changeLight(ColorRGB color, Point3D target) {
        this.lightColor = color;
        this.lightPosition = target;
    }

    public ColorRGB getLightColor() {
        return this.lightColor;
    }

    public Point3D getLightPosition() {
        return this.lightPosition;
    }

    public void add(PolygonModel model) {
        this.models.add(model);
        this.observers.forEach(observer -> observer.onModelAdded(model));
    }

    public void remove(PolygonModel model) {
        this.models.remove(model);
        this.observers.forEach(observer -> observer.onModelRemoved(model));
    }

    public Iterable<PolygonModel> getModels() {
        return this.models;
    }

    @Override
    public void update(float deltaTime) {
        for (PolygonModel model : this.models) {
            model.update(deltaTime);
        }
    }
}

