/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.MediaAsset;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;

public interface OutlineFont
extends MediaAsset {
    public FontStyle getStyle();

    public OutlineFont derive(FontStyle var1);

    default public OutlineFont derive(int size) {
        FontStyle style = this.getStyle();
        return this.derive(new FontStyle(style.family(), size, style.bold(), style.color()));
    }

    default public OutlineFont derive(int size, boolean bold) {
        FontStyle style = this.getStyle();
        return this.derive(new FontStyle(style.family(), size, bold, style.color()));
    }

    default public OutlineFont derive(ColorRGB color) {
        FontStyle style = this.getStyle();
        return this.derive(new FontStyle(style.family(), style.size(), style.bold(), color));
    }

    default public OutlineFont scale(Canvas canvas) {
        FontStyle style = this.getStyle();
        int actualDisplaySize = Math.round(canvas.getZoomLevel() * (float)style.size());
        return this.derive(new FontStyle(style.family(), actualDisplaySize, style.bold(), style.color()));
    }
}

