/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import java.util.Set;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.scene.FiniteStateMachine;
import nl.colorize.multimedialib.scene.State;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Transform;

public class Sprite
implements Graphic2D {
    private FiniteStateMachine<Animation> stateMachine = new FiniteStateMachine();
    private boolean visible = true;
    private Point2D position = new Point2D(0.0f, 0.0f);
    private Transform transform = new Transform();
    private static final String DEFAULT_STATE = "$$default";

    public Sprite() {
    }

    public Sprite(Animation anim) {
        this();
        this.addState(DEFAULT_STATE, anim);
    }

    public Sprite(Image image) {
        this();
        this.addState(DEFAULT_STATE, image);
    }

    public void addState(String name, Animation graphics) {
        this.stateMachine.register(State.of(name, graphics));
    }

    public void addState(String name, Image stateGraphics) {
        this.addState(name, new Animation(stateGraphics));
    }

    @Override
    public void update(float deltaTime) {
        this.stateMachine.update(deltaTime);
    }

    public void changeState(String state) {
        this.stateMachine.changeState(state);
    }

    public void resetState() {
        this.stateMachine.resetActiveState();
    }

    public String getActiveState() {
        return this.stateMachine.getActiveState().name();
    }

    public Set<String> getPossibleStates() {
        return this.stateMachine.getPossibleStates().stream().map(State::name).collect(Collectors.toSet());
    }

    public boolean hasState(String stateName) {
        return this.stateMachine.hasPossibleState(stateName);
    }

    public Animation getStateGraphics(String stateName) {
        return this.stateMachine.getPossibleState(stateName).properties();
    }

    public Animation getActiveStateGraphics() {
        return this.getStateGraphics(this.getActiveState());
    }

    public Image getCurrentGraphics() {
        Animation graphics = this.stateMachine.getActiveStateProperties();
        return graphics.getFrameAtTime(this.stateMachine.getActiveStateTime());
    }

    public int getCurrentWidth() {
        return this.getCurrentGraphics().getWidth();
    }

    public int getCurrentHeight() {
        return this.getCurrentGraphics().getHeight();
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setPosition(Point2D p) {
        this.position.set(p);
    }

    @Override
    public void setPosition(float x, float y) {
        this.position.set(x, y);
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    public void setTransform(Transform transform) {
        if (transform == null) {
            transform = new Transform();
        }
        this.transform = transform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public Rect getBounds() {
        float width = Math.max((float)this.getCurrentWidth() * (this.transform.getScaleX() / 100.0f), 1.0f);
        float height = Math.max((float)this.getCurrentHeight() * (this.transform.getScaleY() / 100.0f), 1.0f);
        return new Rect(this.position.getX() - width / 2.0f, this.position.getY() - height / 2.0f, width, height);
    }

    public void scaleTo(float width, float height) {
        float scaleX = width / (float)this.getCurrentWidth() * 100.0f;
        float scaleY = height / (float)this.getCurrentHeight() * 100.0f;
        this.transform.setScale(scaleX, scaleY);
    }

    @Override
    public boolean hitTest(Point2D point) {
        return this.getBounds().contains(point);
    }

    public Sprite copy() {
        Sprite copy = new Sprite();
        for (State<Animation> state : this.stateMachine.getPossibleStates()) {
            copy.addState(state.name(), state.properties());
        }
        copy.changeState(this.stateMachine.getActiveState().name());
        copy.setPosition(this.position.copy());
        copy.setTransform(this.transform.copy());
        return copy;
    }

    public String toString() {
        return "Sprite [" + this.getCurrentGraphics() + " @ " + this.position + "]";
    }
}

