/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Layer2D;
import nl.colorize.multimedialib.stage.Layer3D;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.StageObserver;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.LogHelper;

public class Stage
implements Updatable {
    private Canvas canvas;
    private FrameStats frameStats;
    private ColorRGB backgroundColor;
    private Map<String, Layer2D> layers2D;
    private Layer3D layer3D;
    private List<StageObserver> observers;
    public static final String DEFAULT_LAYER = "$$default";
    private static final Logger LOGGER = LogHelper.getLogger(Stage.class);

    public Stage(GraphicsMode graphicsMode, Canvas canvas, FrameStats frameStats) {
        this.canvas = canvas;
        this.frameStats = frameStats;
        this.backgroundColor = ColorRGB.BLACK;
        this.layers2D = new LinkedHashMap<String, Layer2D>();
        this.observers = new ArrayList<StageObserver>();
        this.addLayer(DEFAULT_LAYER);
        if (graphicsMode == GraphicsMode.MODE_3D) {
            this.layer3D = new Layer3D(this.observers);
        }
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setBackgroundColor(ColorRGB backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public ColorRGB getBackgroundColor() {
        return this.backgroundColor;
    }

    public Layer2D addLayer(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"Invalid layer name");
        Preconditions.checkArgument((!this.layers2D.containsKey(name) ? 1 : 0) != 0, (Object)("Layer with same name already exists: " + name));
        Layer2D layer = new Layer2D(name, this.observers);
        this.layers2D.put(name, layer);
        return layer;
    }

    public Layer2D getLayer(String name) {
        Layer2D layer = this.layers2D.get(name);
        Preconditions.checkArgument((layer != null ? 1 : 0) != 0, (Object)("No such layer: " + name));
        return layer;
    }

    public Layer2D getDefaultLayer() {
        return this.getLayer(DEFAULT_LAYER);
    }

    public boolean hasLayer(String name) {
        return this.layers2D.containsKey(name);
    }

    public Layer2D retrieveLayer(String name) {
        if (this.hasLayer(name)) {
            return this.getLayer(name);
        }
        return this.addLayer(name);
    }

    public Layer3D getLayer3D() {
        if (this.layer3D == null) {
            throw new UnsupportedGraphicsModeException("3D graphics not supported");
        }
        return this.layer3D;
    }

    public void add(String layerName, Graphic2D graphic) {
        this.getLayer(layerName).add(graphic);
    }

    @Deprecated
    public void remove(Graphic2D graphic) {
        this.layers2D.values().forEach(layer -> layer.remove(graphic));
    }

    public void visit(StageVisitor visitor) {
        Rect canvasBounds = this.canvas.getBounds();
        this.frameStats.resetDrawOperations();
        visitor.preVisitStage(this);
        visitor.drawBackground(this.backgroundColor);
        for (Layer2D layer : this.layers2D.values()) {
            visitor.prepareLayer(layer);
            for (Graphic2D graphic : layer.getGraphics()) {
                boolean visible = this.determineGraphicVisible(graphic, canvasBounds);
                visitor.preVisitGraphic(graphic, visible);
                if (!visible) continue;
                this.visitGraphic(graphic, visitor);
                visitor.postVisitGraphic(graphic);
                this.frameStats.markDrawOperation(graphic);
            }
        }
        visitor.postVisitStage(this);
    }

    private boolean determineGraphicVisible(Graphic2D graphic, Rect canvasBounds) {
        return graphic.isVisible() && graphic.getBounds().intersects(canvasBounds);
    }

    private void visitGraphic(Graphic2D graphic, StageVisitor visitor) {
        if (graphic instanceof Sprite) {
            Sprite sprite = (Sprite)graphic;
            visitor.drawSprite(sprite);
        } else if (graphic instanceof Primitive) {
            Primitive primitive = (Primitive)graphic;
            this.visitPrimitive(primitive, visitor);
        } else if (graphic instanceof Text) {
            Text text = (Text)graphic;
            visitor.drawText(text);
        } else {
            LOGGER.warning("Stage contains unknown graphics type: " + graphic);
        }
    }

    private void visitPrimitive(Primitive graphic, StageVisitor visitor) {
        Shape displayedShape = graphic.getShape().reposition(graphic.getPosition());
        switch (graphic.getShapeType()) {
            case 1: {
                visitor.drawLine(graphic, (Line)displayedShape);
                break;
            }
            case 2: {
                visitor.drawRect(graphic, (Rect)displayedShape);
                break;
            }
            case 3: {
                visitor.drawCircle(graphic, (Circle)displayedShape);
                break;
            }
            case 4: {
                visitor.drawPolygon(graphic, (Polygon)displayedShape);
                break;
            }
            default: {
                LOGGER.warning("Stage contains unknown primitive type: " + graphic);
            }
        }
    }

    @Override
    public void update(float deltaTime) {
        for (Layer2D layer : this.layers2D.values()) {
            layer.update(deltaTime);
        }
        if (this.layer3D != null) {
            this.layer3D.update(deltaTime);
        }
    }

    public void clear() {
        this.layers2D.clear();
        this.addLayer(DEFAULT_LAYER);
        if (this.layer3D != null) {
            this.layer3D.clear();
        }
        this.observers.forEach(observer -> observer.onStageCleared());
    }

    public List<StageObserver> getObservers() {
        return this.observers;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Stage\n");
        for (Layer2D layer : ImmutableList.copyOf(this.layers2D.values()).reverse()) {
            buffer.append("    2D graphics layer [" + layer.getName() + "]\n");
            for (Graphic2D graphic : ImmutableList.copyOf(layer.getGraphics()).reverse()) {
                buffer.append("        " + graphic + "\n");
            }
        }
        if (this.layer3D != null) {
            buffer.append("    3D graphics layer\n");
            for (PolygonModel model : this.layer3D.getModels()) {
                buffer.append("        PolygonModel\n");
            }
        }
        return buffer.toString();
    }
}

