/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.stage.ColorRGB;

public class Transform {
    private float rotation;
    private float scaleX;
    private float scaleY;
    private float alpha;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private ColorRGB mask;

    public Transform() {
        this.reset();
    }

    public void reset() {
        this.rotation = 0.0f;
        this.scaleX = 100.0f;
        this.scaleY = 100.0f;
        this.flipHorizontal = false;
        this.flipVertical = false;
        this.alpha = 100.0f;
    }

    public void set(Transform other) {
        this.rotation = other.rotation;
        this.scaleX = other.scaleX;
        this.scaleY = other.scaleY;
        this.alpha = other.alpha;
        this.mask = other.mask;
    }

    public void setRotation(float degrees) {
        this.rotation = degrees % (degrees >= 0.0f ? 360.0f : -360.0f);
    }

    public void addRotation(float degrees) {
        this.setRotation(this.getRotation() + degrees);
    }

    public float getRotation() {
        return this.rotation;
    }

    public float getRotationInRadians() {
        return (float)Math.toRadians(this.rotation);
    }

    public void setScale(float scale) {
        this.setScaleX(scale);
        this.setScaleY(scale);
    }

    public void setScale(float scaleX, float scaleY) {
        this.setScaleX(scaleX);
        this.setScaleY(scaleY);
    }

    public void setScaleX(float scaleX) {
        this.scaleX = Math.max(scaleX, 0.0f);
    }

    public float getScaleX() {
        return this.flipHorizontal ? -this.scaleX : this.scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = Math.max(scaleY, 0.0f);
    }

    public float getScaleY() {
        return this.flipVertical ? -this.scaleY : this.scaleY;
    }

    public void setAlpha(float alpha) {
        this.alpha = MathUtils.clamp(alpha, 0.0f, 100.0f);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
    }

    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    public void setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
    }

    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    public void setMask(ColorRGB mask) {
        this.mask = mask;
    }

    public ColorRGB getMask() {
        return this.mask;
    }

    public Transform copy() {
        Transform other = new Transform();
        other.rotation = this.rotation;
        other.scaleX = this.scaleX;
        other.scaleY = this.scaleY;
        other.alpha = this.alpha;
        other.flipHorizontal = this.flipHorizontal;
        other.flipVertical = this.flipVertical;
        other.mask = this.mask;
        return other;
    }

    public static Transform withRotation(float rotation) {
        Transform transform = new Transform();
        transform.setRotation(rotation);
        return transform;
    }

    public static Transform withScale(float scaleX, float scaleY) {
        Transform transform = new Transform();
        transform.setScaleX(scaleX);
        transform.setScaleY(scaleY);
        return transform;
    }

    public static Transform withScale(float scale) {
        return Transform.withScale(scale, scale);
    }

    public static Transform withAlpha(float alpha) {
        Transform transform = new Transform();
        transform.setAlpha(alpha);
        return transform;
    }

    public static Transform withMask(ColorRGB mask) {
        Transform transform = new Transform();
        transform.setMask(mask);
        return transform;
    }
}

