/* eslint-disable */
 
/*!
 * pixi-heaven - v0.3.3
 * Compiled Tue, 13 Sep 2022 12:16:16 UTC
 *
 * pixi-heaven is licensed under the MIT License.
 * http://www.opensource.org/licenses/mit-license
 * 
 * Copyright 2019-2020, Ivan Popelyshev, All Rights Reserved
 */
this.PIXI = this.PIXI || {};
this.PIXI.heaven = this.PIXI.heaven || {};
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@pixi/spritesheet'), require('@pixi/math'), require('@pixi/core'), require('@pixi/ticker'), require('@pixi/utils'), require('@pixi/constants'), require('@pixi/mesh'), require('@pixi/sprite'), require('@pixi/display'), require('@pixi/text-bitmap'), require('@pixi/graphics')) :
    typeof define === 'function' && define.amd ? define(['exports', '@pixi/spritesheet', '@pixi/math', '@pixi/core', '@pixi/ticker', '@pixi/utils', '@pixi/constants', '@pixi/mesh', '@pixi/sprite', '@pixi/display', '@pixi/text-bitmap', '@pixi/graphics'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.pixi_heaven = {}, global.PIXI, global.PIXI, global.PIXI, global.PIXI, global.PIXI.utils, global.PIXI, global.PIXI, global.PIXI, global.PIXI, global.PIXI, global.PIXI));
}(this, (function (exports, spritesheet, math, core, ticker, utils, constants, mesh, sprite, display, textBitmap, graphics) { 'use strict';

    class TexturePolygon {
        constructor( vertices,  uvs,  indices) {;this.vertices = vertices;this.uvs = uvs;this.indices = indices;
        }
    }

    function applySpritesheetMixin()
    {
        (spritesheet.Spritesheet.prototype )._processFrames = function (initialFrameIndex) {
            const meta = this.data.meta;

            let frameIndex = initialFrameIndex;
            const maxFrames = spritesheet.Spritesheet.BATCH_SIZE;

            while (frameIndex - initialFrameIndex < maxFrames && frameIndex < this._frameKeys.length)
            {
                const i = this._frameKeys[frameIndex];
                const data = this._frames[i];
                const rect = data.frame;

                if (rect)
                {
                    let frame = null;
                    let trim = null;
                    const sourceSize = data.trimmed !== false && data.sourceSize
                        ? data.sourceSize : data.frame;

                    const orig = new math.Rectangle(
                        0,
                        0,
                        Math.floor(sourceSize.w) / this.resolution,
                        Math.floor(sourceSize.h) / this.resolution
                    );

                    if (data.rotated)
                    {
                        frame = new math.Rectangle(
                            Math.floor(rect.x) / this.resolution,
                            Math.floor(rect.y) / this.resolution,
                            Math.floor(rect.h) / this.resolution,
                            Math.floor(rect.w) / this.resolution
                        );
                    }
                    else
                    {
                        frame = new math.Rectangle(
                            Math.floor(rect.x) / this.resolution,
                            Math.floor(rect.y) / this.resolution,
                            Math.floor(rect.w) / this.resolution,
                            Math.floor(rect.h) / this.resolution
                        );
                    }

                    //  Check to see if the sprite is trimmed
                    if (data.trimmed !== false && data.spriteSourceSize)
                    {
                        trim = new math.Rectangle(
                            Math.floor(data.spriteSourceSize.x) / this.resolution,
                            Math.floor(data.spriteSourceSize.y) / this.resolution,
                            Math.floor(rect.w) / this.resolution,
                            Math.floor(rect.h) / this.resolution
                        );
                    }

                    this.textures[i] = new core.Texture(
                        this.baseTexture,
                        frame,
                        orig,
                        trim,
                        data.rotated ? 2 : 0,
                        data.anchor
                    );

                    if (data.vertices) {
                        const vertices = new Float32Array(data.vertices.length * 2);

                        for (let i = 0; i < data.vertices.length; i++) {
                            vertices[i * 2] = Math.floor(data.vertices[i][0] ) / this.resolution;
                            vertices[i * 2 + 1] = Math.floor(data.vertices[i][1] ) / this.resolution;
                        }

                        const uvs = new Float32Array(data.verticesUV.length * 2);

                        for (let i = 0; i < data.verticesUV.length; i++) {
                            uvs[i * 2] = data.verticesUV[i][0] / meta.size.w;
                            uvs[i * 2 + 1] = data.verticesUV[i][1] / meta.size.h;
                        }

                        const indices = new Uint16Array(data.triangles.length * 3);
                        for (let i = 0; i < data.triangles.length; i++) {
                            indices[i * 3] = data.triangles[i][0];
                            indices[i * 3 + 1] = data.triangles[i][1];
                            indices[i * 3 + 2] = data.triangles[i][2];
                        }

                        (this.textures[i] ).polygon = new TexturePolygon(vertices, uvs, indices);
                    }

                    // lets also add the frame to pixi's global cache for 'from' and 'fromLoader' functions
                    core.Texture.addToCache(this.textures[i], i);
                }

                frameIndex++;
            }
        };
    }

    class AnimationState {
        

        __init() {this._textures = null;}
        __init2() {this._durations = null;}
        
        __init3() {this.animationSpeed = 1;}
        
        __init4() {this.loop = true;}
        
        
        
        __init5() {this._currentTime = 0;}
        __init6() {this.playing = false;}

        constructor(textures, autoUpdate) {;AnimationState.prototype.__init.call(this);AnimationState.prototype.__init2.call(this);AnimationState.prototype.__init3.call(this);AnimationState.prototype.__init4.call(this);AnimationState.prototype.__init5.call(this);AnimationState.prototype.__init6.call(this);
            this.texture = textures[0] instanceof core.Texture ? textures[0]  : (textures[0] ).texture;

            this.textures = textures ;

            this._autoUpdate = autoUpdate !== false;
        }

        /**
         * Stops the AnimatedSprite
         *
         */
        stop() {
            if (!this.playing) {
                return;
            }

            this.playing = false;
            if (this._autoUpdate) {
                ticker.Ticker.shared.remove(this.update, this);
            }
        }

        /**
         * Plays the AnimatedSprite
         *
         */
        play() {
            if (this.playing) {
                return;
            }

            this.playing = true;
            if (this._autoUpdate) {
                ticker.Ticker.shared.add(this.update, this, ticker.UPDATE_PRIORITY.HIGH);
            }
        }

        /**
         * Stops the AnimatedSprite and goes to a specific frame
         *
         * @param {number} frameNumber - frame index to stop at
         */
        gotoAndStop(frameNumber) {
            this.stop();

            const previousFrame = this.currentFrame;

            this._currentTime = frameNumber;

            if (previousFrame !== this.currentFrame) {
                this.updateTexture();
            }
        }

        /**
         * Goes to a specific frame and begins playing the AnimatedSprite
         *
         * @param {number} frameNumber - frame index to start at
         */
        gotoAndPlay(frameNumber) {
            const previousFrame = this.currentFrame;

            this._currentTime = frameNumber;

            if (previousFrame !== this.currentFrame) {
                this.updateTexture();
            }

            this.play();
        }

        /**
         * Updates the object transform for rendering.
         *
         * @private
         * @param {number} deltaTime - Time since last tick.
         */
        update(deltaTime) {
            const elapsed = this.animationSpeed * deltaTime;
            const previousFrame = this.currentFrame;

            if (this._durations !== null) {
                let lag = this._currentTime % 1 * this._durations[this.currentFrame];

                lag += elapsed / 60 * 1000;

                while (lag < 0) {
                    this._currentTime--;
                    lag += this._durations[this.currentFrame];
                }

                let sign = this.animationSpeed * deltaTime;

                if (sign < 0) sign = -1;
                else if (sign > 0) sign = 1;

                this._currentTime = Math.floor(this._currentTime);

                while (lag >= this._durations[this.currentFrame]) {
                    lag -= this._durations[this.currentFrame] * sign;
                    this._currentTime += sign;
                }

                this._currentTime += lag / this._durations[this.currentFrame];
            }
            else {
                this._currentTime += elapsed;
            }

            if (this._currentTime < 0 && !this.loop) {
                this.gotoAndStop(0);

                if (this.onComplete) {
                    this.onComplete();
                }
            }
            else if (this._currentTime >= this._textures.length && !this.loop) {
                this.gotoAndStop(this._textures.length - 1);

                if (this.onComplete) {
                    this.onComplete();
                }
            }
            else if (previousFrame !== this.currentFrame) {
                if (this.loop && this.onLoop) {
                    if (this.animationSpeed > 0 && this.currentFrame < previousFrame) {
                        this.onLoop();
                    }
                    else if (this.animationSpeed < 0 && this.currentFrame > previousFrame) {
                        this.onLoop();
                    }
                }

                this.updateTexture();
            }
        }

        /**
         * Updates the displayed texture to match the current frame index
         *
         * @private
         */
        updateTexture() {
            this.texture = this._textures[this.currentFrame];
            if (this._target) {
                this._target.texture = this.texture;
            }
            if (this.onFrameChange) {
                this.onFrameChange(this.currentFrame);
            }
        }

        bind(target) {
            this._target = target;
            target.animState = this;
        }

        /**
         * A short hand way of creating a movieclip from an array of frame ids
         *
         * @static
         * @param {string[]} frames - The array of frames ids the movieclip will use as its texture frames
         * @return {AnimatedSprite} The new animated sprite with the specified frames.
         */
        static fromFrames(frames) {
            const textures = [];

            for (let i = 0; i < frames.length; ++i) {
                textures.push(core.Texture.from(frames[i]));
            }

            return new AnimationState(textures);
        }

        /**
         * A short hand way of creating a movieclip from an array of image ids
         *
         * @static
         * @param {string[]} images - the array of image urls the movieclip will use as its texture frames
         * @return {AnimatedSprite} The new animate sprite with the specified images as frames.
         */
        static fromImages(images) {
            const textures = [];

            for (let i = 0; i < images.length; ++i) {
                textures.push(core.Texture.from(images[i]));
            }

            return new AnimationState(textures);
        }

        /**
         * totalFrames is the total number of frames in the AnimatedSprite. This is the same as number of textures
         * assigned to the AnimatedSprite.
         *
         * @readonly
         * @member {number}
         * @default 0
         */
        get totalFrames() {
            return this._textures.length;
        }

        /**
         * The array of textures used for this AnimatedSprite
         *
         * @member {Texture[]}
         */
        get textures()
        {
            return this._textures;
        }

        set textures(value)
        {
            if (value[0] instanceof core.Texture) {
                this._textures = value ;
                this._durations = null;
            }
            else {
                this._textures = [];
                this._durations = [];

                for (let i = 0; i < value.length; i++) {
                    const val = (value )[i];
                    this._textures.push(val.texture);
                    this._durations.push(val.time);
                }
            }
            this.gotoAndStop(0);
            this.updateTexture();
        }

        get currentFrame()
        {
            let currentFrame = Math.floor(this._currentTime) % this._textures.length;

            if (currentFrame < 0)
            {
                currentFrame += this._textures.length;
            }

            return currentFrame;
        }
    }

    class LoopShaderGenerator {
        __init() {this.programCache = {};}
        __init2() {this.defaultGroupCache = {};}

        constructor( vertexSrc,  fragTemplate,  loops) {;this.vertexSrc = vertexSrc;this.fragTemplate = fragTemplate;this.loops = loops;LoopShaderGenerator.prototype.__init.call(this);LoopShaderGenerator.prototype.__init2.call(this);
            if (fragTemplate.indexOf('%count%') < 0) {
                throw new Error('Fragment template must contain "%count%".');
            }
            for (let i=0;i<loops.length;i++) {
                if (fragTemplate.indexOf(loops[i].loopLabel) < 0) {
                    throw new Error(`Fragment template must contain "${loops[i].loopLabel}".`);
                }
            }
        }

        generateShader(maxTextures) {
            if (!this.programCache[maxTextures]) {
                const sampleValues = new Int32Array(maxTextures);
                const { loops } = this;

                for (let i = 0; i < maxTextures; i++) {
                    sampleValues[i] = i;
                }

                this.defaultGroupCache[maxTextures] = new core.UniformGroup({uSamplers: sampleValues}, true);

                let fragmentSrc = this.fragTemplate;

                for (let i=0;i<loops.length;i++) {
                    fragmentSrc = fragmentSrc.replace(/%count%/gi, `${maxTextures}`);
                    fragmentSrc = fragmentSrc.replace(new RegExp(loops[i].loopLabel, 'gi'), this.generateSampleSrc(maxTextures, loops[i]));
                }

                this.programCache[maxTextures] = new core.Program(this.vertexSrc, fragmentSrc);
            }

            // TODO: move this to generator parameters
            const uniforms = {
                tint: new Float32Array([1, 1, 1, 1]),
                translationMatrix: new math.Matrix(),
                default: this.defaultGroupCache[maxTextures],
            };

            return new core.Shader(this.programCache[maxTextures], uniforms);
        }

        generateSampleSrc(maxTextures, loop) {
            let src = '';

            src += '\n';
            src += '\n';

            for (let i = 0; i < maxTextures; i++) {
                if (i > 0) {
                    src += '\nelse ';
                }

                if (i < maxTextures - 1) {
                    src += `if(${loop.inTex} < ${i}.5)`;
                }

                src += '\n{';
                src += `\n\t${loop.outColor} = texture2D(uSamplers[${i}], ${loop.inCoord});`;
                src += '\n}';
            }

            src += '\n';
            src += '\n';

            return src;
        }
    }

    const WHITE = core.Texture.WHITE.baseTexture;

    const shaderVert$1 =
        `precision highp float;
attribute vec2 aVertexPosition;
attribute vec2 aTextureCoord;
attribute vec4 aLight, aDark;
attribute float aTextureId;
attribute vec2 aMaskCoord;
attribute vec4 aMaskClamp;

uniform mat3 projectionMatrix;
uniform mat3 translationMatrix;
uniform vec4 tint;

varying vec2 vTextureCoord;
varying vec4 vLight, vDark;
varying float vTextureId;
varying vec2 vMaskCoord;
varying vec4 vMaskClamp;

void main(void){
gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);

vTextureCoord = aTextureCoord;
vTextureId = aTextureId;
vLight = aLight * tint;
vDark = vec4(aDark.rgb * tint.rgb, aDark.a);
vMaskCoord = aMaskCoord;
vMaskClamp = aMaskClamp;
}
`;
    const shaderFrag$1 = `
varying vec2 vTextureCoord;
varying vec2 vMaskCoord;
varying vec4 vMaskClamp;
varying vec4 vLight, vDark;
varying float vTextureId;
uniform sampler2D uSamplers[%count%];

void main(void) {
vec4 texColor, maskColor, fragColor;

float maskBits = floor((vTextureId + 0.5) / 64.0);
float textureId = floor(0.5 + vTextureId - maskBits * 64.0);
float maskId = floor((maskBits + 0.5) / 16.0);
maskBits = maskBits - maskId * 16.0;

float clipEnable = step(0.5, maskBits);

float clip = step(3.5,
    step(vMaskClamp.x, vMaskCoord.x) +
    step(vMaskClamp.y, vMaskCoord.y) +
    step(vMaskCoord.x, vMaskClamp.z) +
    step(vMaskCoord.y, vMaskClamp.w));
%loopTex%
%loopMask%
fragColor.a = texColor.a * vLight.a;
fragColor.rgb = ((texColor.a - 1.0) * vDark.a + 1.0 - texColor.rgb) * vDark.rgb + texColor.rgb * vLight.rgb;
gl_FragColor = fragColor * maskColor.r * (clipEnable * clip + 1.0 - clipEnable);
}`;
    const tempArray = new Float32Array([0, 0, 0, 0]);

    class MaskedGeometry extends core.Geometry {
        
        

        constructor(_static = false) {
            super();

            this._buffer = new core.Buffer(null, _static, false);

            this._indexBuffer = new core.Buffer(null, _static, true);

            this.addAttribute('aVertexPosition', this._buffer, 2, false, constants.TYPES.FLOAT)
                .addAttribute('aTextureCoord', this._buffer, 2, false, constants.TYPES.FLOAT)
                .addAttribute('aLight', this._buffer, 4, true, constants.TYPES.UNSIGNED_BYTE)
                .addAttribute('aDark', this._buffer, 4, true, constants.TYPES.UNSIGNED_BYTE)
                .addAttribute('aTextureId', this._buffer, 1, true, constants.TYPES.FLOAT)
                .addAttribute('aMaskCoord', this._buffer, 2, false, constants.TYPES.FLOAT)
                .addAttribute('aMaskClamp', this._buffer, 4, false, constants.TYPES.FLOAT)
                .addIndex(this._indexBuffer);
        }
    }

    const elemTex = [null, null];

    class MaskedPluginFactory {
        static __initStatic() {this.MAX_TEXTURES = 8;}

        static create(options) {
            const {vertex, fragment, vertexSize, geometryClass} = (Object ).assign({
                vertex: shaderVert$1,
                fragment: shaderFrag$1,
                geometryClass: MaskedGeometry,
                vertexSize: 13,
            }, options);

            return class BatchPlugin extends core.AbstractBatchRenderer {
                constructor(renderer) {
                    super(renderer);

                    this.shaderGenerator = new LoopShaderGenerator(vertex, fragment,
                        [{
                            loopLabel: '%loopTex%',
                            inCoord: 'vTextureCoord',
                            outColor: 'texColor',
                            inTex: 'textureId',
                        }, {
                            loopLabel: '%loopMask%',
                            inCoord: 'vMaskCoord',
                            outColor: 'maskColor',
                            inTex: 'maskId',
                        }]) ;
                    this.geometryClass = geometryClass;
                    this.vertexSize = vertexSize;
                }

                

                contextChange() {
                    const thisAny = this ;
                    const batchMAX_TEXTURES = thisAny.renderer.plugins['batch'].MAX_TEXTURES * 2;

                    thisAny.MAX_TEXTURES = Math.max(2, Math.min(MaskedPluginFactory.MAX_TEXTURES, batchMAX_TEXTURES));
                    this._shader = thisAny.shaderGenerator.generateShader(this.MAX_TEXTURES);

                    // we use the second shader as the first one depending on your browser
                    // may omit aTextureId as it is not used by the shader so is optimized out.
                    for (let i = 0; i < thisAny._packedGeometryPoolSize; i++) {
                        /* eslint-disable max-len */
                        thisAny._packedGeometries[i] = new (this.geometryClass)();
                    }

                    this.initFlushBuffers();
                }

                buildTexturesAndDrawCalls() {
                    const textures = (this )._bufferedTextures;
                    const elements = (this )._bufferedElements;
                    const _bufferSize = (this )._bufferSize;
                    const {
                        MAX_TEXTURES
                    } = this;
                    const textureArrays = core.AbstractBatchRenderer._textureArrayPool;
                    const batch = this.renderer.batch;
                    const boundTextures = (this )._tempBoundTextures;
                    const touch = this.renderer.textureGC.count;

                    let TICK = ++core.BaseTexture._globalBatch;
                    let countTexArrays = 0;
                    let texArray = textureArrays[0];
                    let start = 0;

                    batch.copyBoundTextures(boundTextures, MAX_TEXTURES);

                    for (let i = 0; i < _bufferSize; ++i) {
                        // here are my changes, use two textures instead of one
                        // use WHITE as default mask
                        const maskTexNull = elements[i].maskSprite ? elements[i].maskSprite.texture.baseTexture : null;
                        elemTex[0] = maskTexNull && maskTexNull.valid ? maskTexNull : WHITE;
                        elemTex[1] = textures[i];
                        textures[i] = null;

                        const cnt = (elemTex[0]._batchEnabled !== TICK ? 1 : 0) +
                            (elemTex[1]._batchEnabled !== TICK ? 1 : 0);

                        if (texArray.count + cnt > MAX_TEXTURES) {
                            batch.boundArray(texArray, boundTextures, TICK, MAX_TEXTURES);
                            this.buildDrawCalls(texArray, start, i);
                            start = i;
                            texArray = textureArrays[++countTexArrays];
                            ++TICK;
                        }

                        for (let j = 0; j < 2; j++) {
                            const tex = elemTex[j];

                            if (tex._batchEnabled !== TICK) {
                                tex._batchEnabled = TICK;
                                (tex ).touched = touch;
                                texArray.elements[texArray.count++] = tex;
                            }
                        }
                    }

                    if (texArray.count > 0) {
                        batch.boundArray(texArray, boundTextures, TICK, MAX_TEXTURES);
                        this.buildDrawCalls(texArray, start, _bufferSize);
                        ++countTexArrays;
                        ++TICK;
                    }

                    // Clean-up

                    for (let i = 0; i < boundTextures.length; i++) {
                        boundTextures[i] = null;
                    }
                    core.BaseTexture._globalBatch = TICK;
                }

                packInterleavedGeometry(element, attributeBuffer, indexBuffer, aIndex, iIndex) {
                    const {
                        uint32View,
                        float32View,
                    } = attributeBuffer;

                    let lightRgba = -1;
                    let darkRgba = 0;

                    if (element.color) {
                        lightRgba = element.color.lightRgba;
                        darkRgba = element.color.darkRgba;
                    } else {
                        const alpha = Math.min(element.worldAlpha, 1.0);
                        lightRgba = (alpha < 1.0
                            && element._texture.baseTexture.premultiplyAlpha)
                            ? utils.premultiplyTint(element._tintRGB, alpha)
                            : element._tintRGB + (alpha * 255 << 24);
                    }

                    const p = aIndex / this.vertexSize;
                    const uvs = element.uvs;
                    const indices = element.indices;
                    const vertexData = element.vertexData;
                    const textureId = element._texture.baseTexture._batchLocation;
                    let maskTex = WHITE;

                    const mask = element.maskSprite;
                    let clamp = tempArray;
                    let maskVertexData = tempArray;
                    let maskBit = 0;

                    if (mask) {
                        //TODO: exclude from batcher, move it to element render()
                        element.calculateMaskVertices();
                        clamp = mask._texture.uvMatrix.uClampFrame;
                        maskVertexData = element.maskVertexData;
                        if (mask.texture.valid) {
                            maskTex = mask.texture.baseTexture;
                            maskBit = 1;
                        }
                    }

                    for (let i = 0; i < vertexData.length; i += 2) {
                        float32View[aIndex++] = vertexData[i];
                        float32View[aIndex++] = vertexData[i + 1];
                        float32View[aIndex++] = uvs[i];
                        float32View[aIndex++] = uvs[i + 1];
                        uint32View[aIndex++] = lightRgba;
                        uint32View[aIndex++] = darkRgba;
                        float32View[aIndex++] = ((maskTex._batchLocation * 16.0 + maskBit) * 64.0) + textureId;

                        float32View[aIndex++] = maskVertexData[i];
                        float32View[aIndex++] = maskVertexData[i + 1];
                        float32View[aIndex++] = clamp[0];
                        float32View[aIndex++] = clamp[1];
                        float32View[aIndex++] = clamp[2];
                        float32View[aIndex++] = clamp[3];
                    }

                    for (let i = 0; i < indices.length; i++) {
                        indexBuffer[iIndex++] = p + indices[i];
                    }
                }
            };
        }
    } MaskedPluginFactory.__initStatic();

    const whiteRgba = [1.0, 1.0, 1.0, 1.0];
    const blackRgba = [0.0, 0.0, 0.0, 1.0];

    class ColorTransform {constructor() { ColorTransform.prototype.__init.call(this);ColorTransform.prototype.__init2.call(this);ColorTransform.prototype.__init3.call(this);ColorTransform.prototype.__init4.call(this);ColorTransform.prototype.__init5.call(this);ColorTransform.prototype.__init6.call(this);ColorTransform.prototype.__init7.call(this); }
        __init() {this.dark = new Float32Array(blackRgba);}
        __init2() {this.light = new Float32Array(whiteRgba);}

        __init3() {this._updateID = 0;}
        __init4() {this._currentUpdateID = -1;}

        __init5() {this.darkRgba = 0;}
        __init6() {this.lightRgba = -1;}
        __init7() {this.hasNoTint = true;}

        get darkR() {
            return this.dark[0];
        }

        set darkR(value) {
            if (this.dark[0] === value) return;
            this.dark[0] = value;
            this._updateID++;
        }

        get darkG() {
            return this.dark[1];
        }

        set darkG(value) {
            if (this.dark[1] === value) return;
            this.dark[1] = value;
            this._updateID++;
        }

        get darkB() {
            return this.dark[2];
        }

        set darkB(value) {
            if (this.dark[2] === value) return;
            this.dark[2] = value;
            this._updateID++;
        }

        get lightR() {
            return this.light[0];
        }

        set lightR(value) {
            if (this.light[0] === value) return;
            this.light[0] = value;
            this._updateID++;
        }

        get lightG() {
            return this.light[1];
        }

        set lightG(value) {
            if (this.light[1] === value) return;
            this.light[1] = value;
            this._updateID++;
        }

        get lightB() {
            return this.light[2];
        }

        set lightB(value) {
            if (this.light[2] === value) return;
            this.light[2] = value;
            this._updateID++;
        }

        get alpha() {
            return this.light[3];
        }

        set alpha(value) {
            if (this.light[3] === value) return;
            this.light[3] = value;
            this._updateID++;
        }

        get pma() {
            return this.dark[3] !== 0.0;
        }

        set pma(value) {
            if ((this.dark[3] !== 0.0) !== value) return;
            this.dark[3] = value ? 1.0 : 0.0;
            this._updateID++;
        }

        get tintBGR() {
            const light = this.light;
            return ((light[0] * 255) << 16) + ((light[1] * 255) << 8) + (light[2] * 255 | 0);
        }

        set tintBGR(value) {
            this.setLight(
                ((value >> 16) & 0xff) / 255.0,
                ((value >> 8) & 0xff) / 255.0,
                (value & 0xff) / 255.0
            );
        }

        setLight(R, G, B) {
            const color = this.light;

            if (color[0] === R && color[1] === G && color[2] === B) {
                return;
            }
            color[0] = R;
            color[1] = G;
            color[2] = B;
            this._updateID++;
        }

        setDark(R, G, B) {
            const color = this.dark;

            if (color[0] === R && color[1] === G && color[2] === B) {
                return;
            }
            color[0] = R;
            color[1] = G;
            color[2] = B;
            this._updateID++;
        }

        clear() {
            this.dark[0] = 0.0;
            this.dark[1] = 0.0;
            this.dark[2] = 0.0;
            this.light[0] = 1.0;
            this.light[1] = 1.0;
            this.light[2] = 1.0;
        }

        invalidate() {
            this._updateID++;
        }

        updateTransformLocal() {
            const dark = this.dark, light = this.light;
            const la = 255 * (1.0 + (light[3] - 1.0) * dark[3]);
            this.hasNoTint = dark[0] === 0.0 && dark[1] === 0.0 && dark[2] === 0.0
                && light[0] === 1.0 && light[1] === 1.0 && light[2] === 1.0;
            this.darkRgba = (dark[0] * la | 0) + ((dark[1] * la) << 8)
                + ((dark[2] * la) << 16) + ((dark[3] * 255) << 24);
            this.lightRgba = (light[0] * la | 0) + ((light[1] * la) << 8)
                + ((light[2] * la) << 16) + ((light[3] * 255) << 24);
            this._currentUpdateID = this._updateID;
        }

        updateTransform() {
            if (this._currentUpdateID === this._updateID) {
                return;
            }
            this.updateTransformLocal();
        }
    }

    const tempMat = new math.Matrix();

    const defIndices = new Uint16Array([0, 1, 2, 0, 2, 3]);

    class SpriteH extends sprite.Sprite  {
        __init() {this.color = new ColorTransform();}
        __init2() {this.maskSprite = null;}
        __init3() {this.maskVertexData = null;}
        __init4() {this.uvs = null;}
        __init5() {this.indices = defIndices;}
        __init6() {this.animState = null;}
        // modified by renderer
        __init7() {this.blendAddUnity = false;}

        constructor(texture) {
            super(texture);SpriteH.prototype.__init.call(this);SpriteH.prototype.__init2.call(this);SpriteH.prototype.__init3.call(this);SpriteH.prototype.__init4.call(this);SpriteH.prototype.__init5.call(this);SpriteH.prototype.__init6.call(this);SpriteH.prototype.__init7.call(this);;
            this.pluginName = 'batchHeaven';
            if (this.texture.valid) this._onTextureUpdate();
        }

        get _tintRGB() {
            this.color.updateTransform();
            return this.color.lightRgba & 0xffffff;
        }

        set _tintRGB(value) {
            //nothing
        }

        get tint() {
            return this.color ? this.color.tintBGR : 0xffffff;
        }

        set tint(value) {
            this.color && (this.color.tintBGR = value);
        }

        _onTextureUpdate() {
            const thisAny = this ;
            thisAny._textureID = -1;
            thisAny._textureTrimmedID = -1;

            const texture = thisAny._texture;
            if (texture.polygon) {
                this.uvs = texture.polygon.uvs;
                this.indices = texture.polygon.indices;
            } else {
                this.uvs = texture._uvs.uvsFloat32;
                this.indices = defIndices;
            }

            this._cachedTint = 0xFFFFFF;
            if (this.color) {
                this.color.pma = thisAny._texture.baseTexture.premultipliedAlpha;
            }

            // so if _width is 0 then width was not set..
            if (thisAny._width) {
                this.scale.x = utils.sign(this.scale.x) * thisAny._width / thisAny._texture.orig.width;
            }

            if (thisAny._height) {
                this.scale.y = utils.sign(this.scale.y) * thisAny._height / thisAny._texture.orig.height;
            }
        }

        _render(renderer) {
            this.color.alpha = this.worldAlpha;
            this.color.updateTransform();
            super._render(renderer);
        }

        _calculateBounds() {
            const thisAny = this ;
            const polygon = (thisAny ).polygon;
            const trim = thisAny.trim;
            const orig = thisAny.orig;

            // F irst lets check to see if the current texture has a trim..
            if (!polygon && (!trim || (trim.width === orig.width && trim.height === orig.height))) {
                // no trim! lets use the usual calculations..
                this.calculateVertices();
                this._bounds.addQuad(thisAny.vertexData );
            } else {
                // lets calculate a special trimmed bounds...
                this.calculateTrimmedVertices();
                this._bounds.addQuad(thisAny.vertexTrimmedData );
            }
        }

        calculateVertices() {
            const thisAny = this ;
            const transform = this.transform ;
            const texture = thisAny._texture ;

            if (thisAny._transformID === transform._worldID && thisAny._textureID === texture._updateID) {
                return;
            }

            thisAny._transformID = transform._worldID;
            thisAny._textureID = texture._updateID;

            // set the vertex data

            const wt = this.transform.worldTransform;
            const a = wt.a;
            const b = wt.b;
            const c = wt.c;
            const d = wt.d;
            const tx = wt.tx;
            const ty = wt.ty;
            const anchor = thisAny._anchor ;
            const orig = texture.orig;

            if (texture.polygon) {
                const vertices = texture.polygon.vertices;
                const n = vertices.length;

                if (thisAny.vertexData.length !== n) {
                    thisAny.vertexData = new Float32Array(n);
                }

                const vertexData = thisAny.vertexData;

                const dx = -(anchor._x * orig.width);
                const dy = -(anchor._y * orig.height);

                for (let i = 0; i < n; i += 2) {
                    const x = vertices[i] + dx;
                    const y = vertices[i + 1] + dy;

                    vertexData[i] = x * a + y * c + tx;
                    vertexData[i + 1] = x * b + y * d + ty;
                }
            } else {
                const vertexData = thisAny.vertexData;
                const trim = texture.trim;

                let w0 = 0;
                let w1 = 0;
                let h0 = 0;
                let h1 = 0;

                if (trim) {
                    // if the sprite is trimmed and is not a tilingsprite then we need to add the extra
                    // space before transforming the sprite coords.
                    w1 = trim.x - (anchor._x * orig.width);
                    w0 = w1 + trim.width;

                    h1 = trim.y - (anchor._y * orig.height);
                    h0 = h1 + trim.height;
                } else {
                    w1 = -anchor._x * orig.width;
                    w0 = w1 + orig.width;

                    h1 = -anchor._y * orig.height;
                    h0 = h1 + orig.height;
                }

                // xy
                vertexData[0] = (a * w1) + (c * h1) + tx;
                vertexData[1] = (d * h1) + (b * w1) + ty;

                // xy
                vertexData[2] = (a * w0) + (c * h1) + tx;
                vertexData[3] = (d * h1) + (b * w0) + ty;

                // xy
                vertexData[4] = (a * w0) + (c * h0) + tx;
                vertexData[5] = (d * h0) + (b * w0) + ty;

                // xy
                vertexData[6] = (a * w1) + (c * h0) + tx;
                vertexData[7] = (d * h0) + (b * w1) + ty;
            }
        }

        calculateMaskVertices() {
            //WE HAVE A MASK
            const maskSprite = this.maskSprite;
            const tex = maskSprite.texture;
            const orig = tex.orig;
            const anchor = maskSprite.anchor;

            if (!tex.valid) {
                return;
            }
            if (!tex.uvMatrix) {
                // margin = 0.0, let it bleed a bit, shader code becomes easier
                // assuming that atlas textures were made with 1-pixel padding
                tex.uvMatrix = new core.TextureMatrix(tex, 0.0);
            }
            tex.uvMatrix.update();

            //same operations as in SpriteMaskFilter
            maskSprite.transform.worldTransform.copyTo(tempMat);
            tempMat.invert();
            tempMat.scale(1.0 / orig.width, 1.0 / orig.height);
            tempMat.translate(anchor.x, anchor.y);
            tempMat.prepend(tex.uvMatrix.mapCoord);

            const vertexData = (this ).vertexData;
            const n = vertexData.length;

            if (!this.maskVertexData || this.maskVertexData.length !== n) {
                this.maskVertexData = new Float32Array(n);
            }

            const maskVertexData = this.maskVertexData;

            for (let i = 0; i < n; i += 2) {
                maskVertexData[i] = vertexData[i] * tempMat.a + vertexData[i + 1] * tempMat.c + tempMat.tx;
                maskVertexData[i + 1] = vertexData[i] * tempMat.b + vertexData[i + 1] * tempMat.d + tempMat.ty;
            }
        }

        destroy(options) {
            if (this.animState) {
                this.animState.stop();
                this.animState = null;
            }
            super.destroy(options);
        }
    }

    exports.CLAMP_OPTIONS = void 0; (function (CLAMP_OPTIONS) {
        const NEVER = 0; CLAMP_OPTIONS[CLAMP_OPTIONS["NEVER"] = NEVER] = "NEVER";
        const AUTO = 1; CLAMP_OPTIONS[CLAMP_OPTIONS["AUTO"] = AUTO] = "AUTO";
        const ALWAYS = 2; CLAMP_OPTIONS[CLAMP_OPTIONS["ALWAYS"] = ALWAYS] = "ALWAYS";
    })(exports.CLAMP_OPTIONS || (exports.CLAMP_OPTIONS = {}));






    const settings = {
        MESH_CLAMP: exports.CLAMP_OPTIONS.AUTO,
        BLEND_ADD_UNITY: false,
    };

    const vertex = `attribute vec2 aVertexPosition;
attribute vec2 aTextureCoord;

uniform mat3 projectionMatrix;
uniform mat3 translationMatrix;
uniform mat3 uTextureMatrix;

varying vec2 vTextureCoord;

void main(void)
{
    gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);

    vTextureCoord = (uTextureMatrix * vec3(aTextureCoord, 1.0)).xy;
}`;

    const fragment = `varying vec2 vTextureCoord;
uniform vec4 uLight, uDark;

uniform sampler2D uSampler;

void main(void)
{
vec4 texColor = texture2D(uSampler, vTextureCoord);
gl_FragColor.a = texColor.a * uLight.a;
gl_FragColor.rgb = ((texColor.a - 1.0) * uDark.a + 1.0 - texColor.rgb) * uDark.rgb + texColor.rgb * uLight.rgb;
}
`;

    const fragTrim = `
varying vec2 vTextureCoord;
uniform vec4 uLight, uDark;
uniform vec4 uClampFrame;

uniform sampler2D uSampler;

void main(void)
{
    vec2 coord = vTextureCoord;
    if (coord.x < uClampFrame.x || coord.x > uClampFrame.z
        || coord.y < uClampFrame.y || coord.y > uClampFrame.w)
            discard;
    vec4 texColor = texture2D(uSampler, vTextureCoord);
    gl_FragColor.a = texColor.a * uLight.a;
    gl_FragColor.rgb = ((texColor.a - 1.0) * uDark.a + 1.0 - texColor.rgb) * uDark.rgb + texColor.rgb * uLight.rgb;
}
`;

    class DoubleTintMeshMaterial extends core.Shader {
        
        
        
        
        
        

        constructor(uSampler, options) {
            const uniforms = {
                uSampler,
                uTextureMatrix: math.Matrix.IDENTITY,
                uDark: new Float32Array([0, 0, 0, 1]),
                uLight: new Float32Array([1, 1, 1, 1]),
            };

            // Set defaults
            options = (Object ).assign({
                pluginName: 'batchHeaven',
            }, options);

            let allowTrim = options.allowTrim;

            if (!allowTrim) {
                if (settings.MESH_CLAMP === exports.CLAMP_OPTIONS.AUTO) {
                    allowTrim = uSampler.trim && (uSampler.trim.width < uSampler.orig.width || uSampler.trim.height < uSampler.orig.height);
                } else if (settings.MESH_CLAMP === exports.CLAMP_OPTIONS.ALWAYS) {
                    allowTrim = true;
                }
            }

            if (options.uniforms) {
                (Object ).assign(uniforms, options.uniforms);
            }

            super(options.program || core.Program.from(vertex, allowTrim ? fragTrim: fragment), uniforms);

            this.allowTrim = allowTrim;

            /**
             * TextureMatrix instance for this Mesh, used to track Texture changes
             *
             * @member {TextureMatrix}
             * @readonly
             */
            this.uvMatrix = new core.TextureMatrix(uSampler);

            /**
             * `true` if shader can be batch with the renderer's batch system.
             * @member {boolean}
             * @default true
             */
            this.batchable = options.program === undefined && !this.allowTrim;

            /**
             * Renderer plugin for batching
             *
             * @member {string}
             * @default 'batch'
             */
            this.pluginName = options.pluginName;

            this.color = options.color || new ColorTransform();

            this._colorId = -1;
        }

        /**
         * Reference to the texture being rendered.
         * @member {Texture}
         */
        get texture() {
            return this.uniforms.uSampler;
        }

        set texture(value) {
            if (this.uniforms.uSampler !== value) {
                this.uniforms.uSampler = value;
                this.uvMatrix.texture = value;
                this.color.pma = value.baseTexture.premultiplyAlpha;
            }
        }

        /**
         * This gets automatically set by the object using this.
         *
         * @default 1
         * @member {number}
         */
        set alpha(value) {
            this.color.alpha = value;
        }

        get alpha() {
            return this.color.alpha;
        }

        /**
         * Multiply tint for the material.
         * @member {number}
         * @default 0xFFFFFF
         */
        set tint(value) {
            this.color.tintBGR = value;
        }

        get tint() {
            return this.color.tintBGR;
        }

        /**
         * Gets called automatically by the Mesh. Intended to be overridden for custom
         * MeshMaterial objects.
         */
        update() {
            this.color.updateTransform();
            if (this._colorId !== this.color._updateID) {
                this._colorId = this.color._updateID;
                const { color, uniforms } = this;
                utils.premultiplyRgba(color.light, color.light[3], uniforms.uLight, color.dark[3] > 0.0);
                utils.premultiplyRgba(color.dark, color.light[3], uniforms.uDark, color.dark[3] > 0.0);
                uniforms.uDark[3] = color.dark[3];
            }

            if (this.uvMatrix.update()) {
                this.uniforms.uTextureMatrix = this.uvMatrix.mapCoord;
                if (this.allowTrim) {
                    this.uniforms.uClampFrame = this.uvMatrix.uClampFrame;
                }
            }
        }
    }

    class MeshH extends mesh.Mesh {
        __init() {this.color = null;}
        __init2() {this.maskSprite = null;}
        __init3() {this.maskVertexData = null;}
        __init4() {this.useSpriteMask = false;}

        constructor(geometry, shader, state, drawMode) {
            super(geometry, shader , state, drawMode);MeshH.prototype.__init.call(this);MeshH.prototype.__init2.call(this);MeshH.prototype.__init3.call(this);MeshH.prototype.__init4.call(this);;
            this.color = shader.color;
        }

        _renderDefault(renderer) {
            const shader = this.shader ;

            shader.color.alpha = this.worldAlpha;
            if (shader.update) {
                shader.update();
            }

            renderer.batch.flush();

            shader.uniforms.translationMatrix = this.worldTransform.toArray(true);

            // bind and sync uniforms..
            renderer.shader.bind(shader, false);

            // set state..
            renderer.state.set(this.state);

            // bind the geometry...
            renderer.geometry.bind(this.geometry, shader);

            // then render it
            renderer.geometry.draw(this.drawMode, this.size, this.start, (this.geometry ).instanceCount);
        }

        _render(renderer) {
            // part of SimpleMesh
            if (this.maskSprite) {
                this.useSpriteMask = true;
            }
            if (this.useSpriteMask) {
                (this.material ).pluginName = 'batchMasked';
                this._renderToBatch(renderer);
            } else {
                super._render(renderer);
            }
        }

        _renderToBatch(renderer)
        {
            this.color.updateTransform();
            super._renderToBatch(renderer);
        }

        calculateMaskVertices() {
            SpriteH.prototype.calculateMaskVertices.call(this);
        }
    }


    class SimpleMeshH extends MeshH {
        constructor(texture, vertices, uvs,
                    indices, drawMode) {
            super(new mesh.MeshGeometry(vertices, uvs, indices),
                new DoubleTintMeshMaterial(texture),
                null,
                drawMode);SimpleMeshH.prototype.__init5.call(this);;

            (this.geometry.getBuffer('aVertexPosition') ).static = false;
        }

        __init5() {this.autoUpdate = true;}

        get vertices() {
            return this.geometry.getBuffer('aVertexPosition').data ;
        }

        set vertices(value) {
            this.geometry.getBuffer('aVertexPosition').data = value;
        }

        _render(renderer) {
            if (this.autoUpdate) {
                this.geometry.getBuffer('aVertexPosition').update();
            }

            (super._render )(renderer);
        }
    }

    function applyConvertMixins() {
        // eslint-disable-next-line @typescript-eslint/no-empty-function
        display.Container.prototype.convertToHeaven = function () {
        };

        function tintGet() {
            return this.color.tintBGR;
        }

        function tintSet(value) {
            this.color.tintBGR = value;
        }

        function tintRGBGet() {
            this.color.updateTransform();
            return this.color.lightRgba & 0xffffff;
        }

        const SpriteProto = SpriteH.prototype ;

        sprite.Sprite.prototype.convertToHeaven = function () {
            if (this.color) {
                return;
            }

            Object.defineProperty(this, "tint", {
                get: tintGet,
                set: tintSet,
                enumerable: true,
                configurable: true
            });
            Object.defineProperty(this, "_tintRGB", {
                get: tintRGBGet,
                enumerable: true,
                configurable: true
            });
            this._onTextureUpdate = SpriteProto._onTextureUpdate;
            this._render = SpriteProto._render;
            this._calculateBounds = SpriteProto._calculateBounds;
            this.calculateVertices = SpriteProto.calculateVertices;
            this._onTextureUpdate = SpriteProto._onTextureUpdate;
            this.calculateMaskVertices = SpriteProto.calculateMaskVertices;
            this.destroy = SpriteH.prototype.destroy;
            this.color = new ColorTransform();
            this.pluginName = 'batchHeaven';

            if (this._texture.valid) {
                this._onTextureUpdate();
            } else {
                this._texture.off('update', this._onTextureUpdate);
                this._texture.on('update', this._onTextureUpdate, this);
            }
            return this;
        };

        display.Container.prototype.convertSubtreeToHeaven = function () {
            if (this.convertToHeaven) {
                this.convertToHeaven();
            }
            for (let i = 0; i < this.children.length; i++) {
                this.children[i].convertSubtreeToHeaven();
            }
        };
    }

    const shaderVert =
`precision highp float;
attribute vec2 aVertexPosition;
attribute vec2 aTextureCoord;
attribute vec4 aLight, aDark;
attribute float aTextureId;

uniform mat3 projectionMatrix;
uniform mat3 translationMatrix;
uniform vec4 tint;

varying vec2 vTextureCoord;
varying vec4 vLight, vDark;
varying float vTextureId;

void main(void){
gl_Position = vec4((projectionMatrix * translationMatrix * vec3(aVertexPosition, 1.0)).xy, 0.0, 1.0);

vTextureCoord = aTextureCoord;
vTextureId = aTextureId;
vLight = aLight * tint;
vDark = vec4(aDark.rgb * tint.rgb, aDark.a);
}
`    ;
    const shaderFrag = `
varying vec2 vTextureCoord;
varying vec4 vLight, vDark;
varying float vTextureId;
uniform sampler2D uSamplers[%count%];

void main(void) {
vec4 color;
float textureId = floor(vTextureId+0.5);
%forloop%
gl_FragColor.a = color.a * vLight.a;
gl_FragColor.rgb = ((color.a - 1.0) * vDark.a + 1.0 - color.rgb) * vDark.rgb + color.rgb * vLight.rgb;
}`;

    class DarkLightGeometry extends core.Geometry
    {
        
        

        constructor(_static = false)
        {
            super();

            this._buffer = new core.Buffer(null, _static, false);

            this._indexBuffer = new core.Buffer(null, _static, true);

            this.addAttribute('aVertexPosition', this._buffer, 2, false, constants.TYPES.FLOAT)
                .addAttribute('aTextureCoord', this._buffer, 2, false, constants.TYPES.FLOAT)
                .addAttribute('aLight', this._buffer, 4, true, constants.TYPES.UNSIGNED_BYTE)
                .addAttribute('aDark', this._buffer, 4, true, constants.TYPES.UNSIGNED_BYTE)
                .addAttribute('aTextureId', this._buffer, 1, true, constants.TYPES.FLOAT)
                .addIndex(this._indexBuffer);
        }
    }

    class DarkLightPluginFactory {
        static create(options)
        {
            const { vertex, fragment, vertexSize, geometryClass } = (Object ).assign({
                vertex: shaderVert,
                fragment: shaderFrag,
                geometryClass: DarkLightGeometry,
                vertexSize: 7,
            }, options);

            return class BatchPlugin extends core.AbstractBatchRenderer
            {
                constructor(renderer)
                {
                    super(renderer);

                    this.shaderGenerator = new core.BatchShaderGenerator(vertex, fragment);
                    this.geometryClass = geometryClass;
                    this.vertexSize = vertexSize;
                }

                

                packInterleavedGeometry(element, attributeBuffer, indexBuffer, aIndex, iIndex) {
                    const {
                        uint32View,
                        float32View,
                    } = attributeBuffer;

                    let lightRgba = -1;
                    let darkRgba = 0;

                    if (element.color) {
                        lightRgba = element.color.lightRgba;
                        darkRgba = element.color.darkRgba;
                    } else {
                        const alpha = Math.min(element.worldAlpha, 1.0);
                        lightRgba = (alpha < 1.0
                            && element._texture.baseTexture.premultiplyAlpha)
                            ? utils.premultiplyTint(element._tintRGB, alpha)
                            : element._tintRGB + (alpha * 255 << 24);
                    }

                    if (settings.BLEND_ADD_UNITY && element.blendAddUnity) {
                        lightRgba = lightRgba & 0xffffff;
                    }

                    const p = aIndex / this.vertexSize;
                    const uvs = element.uvs;
                    const indices = element.indices;
                    const vertexData = element.vertexData;
                    const textureId = element._texture.baseTexture._batchLocation;

                    for (let i = 0; i < vertexData.length; i += 2)
                    {
                        float32View[aIndex++] = vertexData[i];
                        float32View[aIndex++] = vertexData[i + 1];
                        float32View[aIndex++] = uvs[i];
                        float32View[aIndex++] = uvs[i + 1];
                        uint32View[aIndex++] = lightRgba;
                        uint32View[aIndex++] = darkRgba;
                        float32View[aIndex++] = textureId;
                    }

                    for (let i = 0; i < indices.length; i++)
                    {
                        indexBuffer[iIndex++] = p + indices[i];
                    }
                }

                /**
                 * I override this method because of special alpha case that can be batched and work with any masks
                 * @param texArray
                 * @param start
                 * @param finish
                 */
                buildDrawCalls(texArray, start, finish)
                {
                    const thisAny = this ;
                    const {
                        _bufferedElements: elements,
                        _attributeBuffer,
                        _indexBuffer,
                        vertexSize,
                    } = thisAny;
                    const drawCalls = core.AbstractBatchRenderer._drawCallPool;

                    let dcIndex = thisAny._dcIndex;
                    let aIndex = thisAny._aIndex;
                    let iIndex = thisAny._iIndex;

                    let drawCall = drawCalls[dcIndex] ;

                    drawCall.start = thisAny._iIndex;
                    drawCall.texArray = texArray;

                    for (let i = start; i < finish; ++i)
                    {
                        const sprite = elements[i];
                        const tex = sprite._texture.baseTexture;
                        let spriteBlendMode = utils.premultiplyBlendMode[
                            tex.alphaMode ? 1 : 0][sprite.blendMode];

                        if (settings.BLEND_ADD_UNITY) {
                            sprite.blendAddUnity = (spriteBlendMode === constants.BLEND_MODES.ADD && tex.alphaMode);
                            if (sprite.blendAddUnity) {
                                spriteBlendMode = constants.BLEND_MODES.NORMAL;
                            }
                        }

                        elements[i] = null;

                        if (start < i && drawCall.blend !== spriteBlendMode)
                        {
                            drawCall.size = iIndex - drawCall.start;
                            start = i;
                            drawCall = drawCalls[++dcIndex];
                            drawCall.texArray = texArray;
                            drawCall.start = iIndex;
                        }

                        this.packInterleavedGeometry(sprite, _attributeBuffer, _indexBuffer, aIndex, iIndex);
                        aIndex += sprite.vertexData.length / 2 * vertexSize;
                        iIndex += sprite.indices.length;

                        drawCall.blend = spriteBlendMode;
                    }

                    if (start < finish)
                    {
                        drawCall.size = iIndex - drawCall.start;
                        ++dcIndex;
                    }

                    thisAny._dcIndex = dcIndex;
                    thisAny._aIndex = aIndex;
                    thisAny._iIndex = iIndex;
                }
            };
        }
    }

    class BitmapTextH extends textBitmap.BitmapText {
        constructor(text, style) {
            super(text, style);
            if (!this.color) {
                this.color = new ColorTransform();
            }
        }

        

        get tint() {
            return this.color ? this.color.tintBGR : 0xffffff;
        }

        set tint(value) {
            this.color && (this.color.tintBGR = value);
        }

        addChild(...additionalChildren) {
            const child = additionalChildren[0] ;
            if (!child.color && child.geometry) {
                if (!this.color) {
                    this.color = new ColorTransform();
                }
                child.color = this.color;
                (child ).material = new DoubleTintMeshMaterial(child.material.texture, { color: this.color });
            }
            return super.addChild(child, ...additionalChildren);
        }

        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        _render(renderer) {
            this.color.alpha = this.worldAlpha;
            this.color.updateTransform();
        }
    }

    core.Renderer.registerPlugin('batchHeaven', DarkLightPluginFactory.create({}));
    core.Renderer.registerPlugin('batchMasked', MaskedPluginFactory.create({}));

    applyConvertMixins();

    class SpineSprite extends SpriteH {
        

        constructor(tex, spine) {
            super(tex);
            this.spine = spine;
        }

        _render(renderer) {
            if (this.maskSprite) {
                (this.spine ).hasSpriteMask = true;
            }
            if ((this.spine ).hasSpriteMask) {
                this.pluginName = 'batchMasked';
            }
            super._render(renderer);
        }
    }

    class SpineMesh extends SimpleMeshH {
        

        constructor(texture, vertices, uvs, indices, drawMode,
                    spine = null) {
            super(texture, vertices, uvs, indices, drawMode);
            this.spine = spine;
        }

        _render(renderer) {
            // part of SimpleMesh
            if (this.autoUpdate)
            {
                this.geometry.getBuffer('aVertexPosition').update();
            }
            if (this.maskSprite) {
                (this.spine ).hasSpriteMask = true;
            }
            if ((this.spine ).hasSpriteMask) {
                (this.material ).pluginName = 'batchMasked';
                this._renderToBatch(renderer);
            } else {
                super._renderDefault(renderer);
            }
        }
    }

    function applySpineMixin(spineClassPrototype)
    {
        spineClassPrototype.newMesh = function newMesh(texture, vertices,
            uvs, indices, drawMode)
        {
            return new SimpleMeshH(texture, vertices, uvs, indices, drawMode) ;
        };
        spineClassPrototype.newContainer = function newMesh()
        {
            if (!this.color)
            {
                this.hasSpriteMask = false;
                this.color = new ColorTransform();
            }
            return new display.Container();
        };
        spineClassPrototype.newSprite = function newSprite(texture)
        {
            return new SpriteH(texture);
        };
        spineClassPrototype.newGraphics = function newMesh()
        {
            return new graphics.Graphics();
        };
        spineClassPrototype.transformHack = function transformHack()
        {
            return 2;
        };
    }

    // eslint-disable-next-line @typescript-eslint/triple-slash-reference,spaced-comment

    applySpritesheetMixin();

    exports.AnimationState = AnimationState;
    exports.BitmapTextH = BitmapTextH;
    exports.ColorTransform = ColorTransform;
    exports.DarkLightGeometry = DarkLightGeometry;
    exports.DarkLightPluginFactory = DarkLightPluginFactory;
    exports.DoubleTintMeshMaterial = DoubleTintMeshMaterial;
    exports.LoopShaderGenerator = LoopShaderGenerator;
    exports.MaskedGeometry = MaskedGeometry;
    exports.MaskedPluginFactory = MaskedPluginFactory;
    exports.MeshH = MeshH;
    exports.SimpleMeshH = SimpleMeshH;
    exports.SpineMesh = SpineMesh;
    exports.SpineSprite = SpineSprite;
    exports.SpriteH = SpriteH;
    exports.TexturePolygon = TexturePolygon;
    exports.applyConvertMixins = applyConvertMixins;
    exports.applySpineMixin = applySpineMixin;
    exports.applySpritesheetMixin = applySpritesheetMixin;
    exports.settings = settings;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
if (typeof pixi_heaven !== 'undefined') { Object.assign(this.PIXI.heaven, pixi_heaven); }
//# sourceMappingURL=pixi-heaven.umd.js.map
