/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.RandomGenerator;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.scene.WipeTransition;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Animation;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.Layer2D;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.SpriteAtlas;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;
import nl.colorize.util.http.Headers;
import nl.colorize.util.http.PostData;
import nl.colorize.util.stats.Tuple;

public class Demo2D
implements Scene,
ErrorHandler {
    private SceneContext context;
    private SpriteAtlas marioSpriteSheet;
    private OutlineFont font;
    private List<Mario> marios;
    private Effect colorizeLogo;
    private Audio audioClip;
    private Text hud;
    public static final int DEFAULT_CANVAS_WIDTH = 800;
    public static final int DEFAULT_CANVAS_HEIGHT = 600;
    private static final FilePointer MARIO_SPRITES_FILE = new FilePointer("demo/demo.png");
    private static final FilePointer AUDIO_FILE = new FilePointer("demo/demo-sound.mp3");
    private static final FilePointer COLORIZE_LOGO = new FilePointer("colorize-logo.png");
    private static final FilePointer FRAGMENT_SHADER = new FilePointer("demo/sepia-fragment.glsl");
    private static final FilePointer VERTEX_SHADER = new FilePointer("demo/sepia-vertex.glsl");
    private static final List<String> DIRECTIONS = List.of("north", "east", "south", "west");
    private static final int BUTTON_WIDTH = 100;
    private static final int BUTTON_HEIGHT = 25;
    private static final ColorRGB RED_BUTTON = new ColorRGB(228, 93, 97);
    private static final ColorRGB GREEN_BUTTON = ColorRGB.parseHex("#72A725");
    private static final ColorRGB PINK_BUTTON = ColorRGB.parseHex("#B75797");
    private static final ColorRGB BACKGROUND_COLOR = ColorRGB.parseHex("#343434");
    private static final Transform MASK_TRANSFORM = Transform.withMask(ColorRGB.WHITE);
    private static final ColorRGB COLORIZE_COLOR = ColorRGB.parseHex("#e45d61");
    private static final String EXAMPLE_URL = "https://dashboard.clrz.nl/rest/echo";

    @Override
    public void start(SceneContext context) {
        this.context = context;
        MediaLoader mediaLoader = context.getMediaLoader();
        context.getStage().setBackgroundColor(BACKGROUND_COLOR);
        this.initMarioSprites(mediaLoader);
        this.marios = new ArrayList<Mario>();
        this.addMarios(context.getStage());
        this.font = mediaLoader.loadDefaultFont(12, ColorRGB.WHITE);
        this.audioClip = mediaLoader.loadAudio(AUDIO_FILE);
        this.initHUD(context);
        this.initEffects();
        this.sendHttpRequest(context.getNetwork());
    }

    private void initMarioSprites(MediaLoader mediaLoader) {
        Image image = mediaLoader.loadImage(MARIO_SPRITES_FILE);
        this.marioSpriteSheet = new SpriteAtlas();
        int y = 0;
        for (String direction : DIRECTIONS) {
            for (int i = 0; i <= 4; ++i) {
                this.marioSpriteSheet.add(direction + "_" + i, image, new Region(i * 48, y, 48, 64));
            }
            y += 64;
        }
    }

    private void initHUD(SceneContext context) {
        Stage stage = context.getStage();
        Layer2D hudLayer = stage.addLayer("hud", 10);
        this.hud = new Text("", this.font);
        this.hud.getPosition().set(20.0f, 20.0f);
        this.hud.setLineHeight(20.0f);
        stage.add("hud", this.hud);
        this.createButton(context, "Add sprites", RED_BUTTON, 0, () -> this.addMarios(stage));
        this.createButton(context, "Remove sprites", RED_BUTTON, 30, () -> this.removeMarios(10));
        this.createButton(context, "Play sound", GREEN_BUTTON, 60, this.audioClip::play);
        this.createButton(context, "Background", GREEN_BUTTON, 90, this::toggleBackgroundColor);
        this.createButton(context, "Cause error", PINK_BUTTON, 120, this::causeError);
        Polygon hexagon = new Polygon(80.0f, 70.0f, 120.0f, 70.0f, 135.0f, 100.0f, 120.0f, 130.0f, 80.0f, 130.0f, 65.0f, 100.0f);
        Primitive hexagonPrimitive = new Primitive(hexagon, COLORIZE_COLOR);
        hexagonPrimitive.setAlpha(50.0f);
        hudLayer.add(hexagonPrimitive);
        Effect effect = new Effect();
        effect.addFrameHandler(deltaTime -> hexagonPrimitive.setPosition(50.0f, (float)stage.getCanvas().getHeight() - 150.0f));
        context.attach(effect);
    }

    private void createButton(SceneContext context, String label, ColorRGB color, int y, Runnable click) {
        Primitive bounds = new Primitive(new Rect(context.getCanvas().getWidth() - 100 - 2, y + 2, 100.0f, 25.0f), color);
        context.getStage().getLayer("hud").add(bounds);
        Text text = new Text(label, this.font, Align.CENTER);
        text.getPosition().set((float)context.getCanvas().getWidth() - 50.0f, y + 19);
        context.getStage().getLayer("hud").add(text);
        Effect effect = new Effect();
        effect.addClickHandler(bounds, click);
        context.attach(effect);
    }

    private void initEffects() {
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(2.0f, 1.0f);
        timeline.addKeyFrame(4.0f, 0.0f);
        Sprite sprite = new Sprite(this.context.getMediaLoader().loadImage(COLORIZE_LOGO));
        this.context.getStage().getLayer("hud").add(sprite);
        this.colorizeLogo = new Effect();
        this.colorizeLogo.addTimelineHandler(timeline, value -> {
            sprite.setPosition(50.0f, this.context.getCanvas().getHeight() - 50);
            sprite.getTransform().setScale(80.0f + value.floatValue() * 40.0f);
        });
        this.colorizeLogo.addFrameHandler(dt -> sprite.getTransform().addRotation(dt * 100.0f));
        this.context.attach(this.colorizeLogo);
        this.context.attach(new WipeTransition(WipeTransition.DIAMOND, COLORIZE_COLOR, 1.5f, true));
    }

    private void sendHttpRequest(Network network) {
        Headers headers = new Headers(new Tuple[]{Tuple.of((Object)"Accept", (Object)"text/plain")});
        PostData data = PostData.create((String)"message", (String)"1234", (String[])new String[0]);
        Text info = new Text("Network request pending", this.font, Align.RIGHT);
        info.setPosition(this.context.getCanvas().getWidth() - 20, this.context.getCanvas().getHeight() - 100);
        this.context.getStage().getLayer("hud").add(info);
        network.post(EXAMPLE_URL, headers, data).then(response -> {
            ArrayList<String> text = new ArrayList<String>();
            text.add("Network request succeeded");
            text.add("Content-Type: " + response.getContentType().orElse("?"));
            text.addAll(Splitter.on((String)"\n").omitEmptyStrings().splitToList((CharSequence)response.getBody()));
            info.setText(text);
        }).thenCatch(e -> info.setText("Failed to send network request"));
    }

    private void toggleBackgroundColor() {
        Stage stage = this.context.getStage();
        if (stage.getBackgroundColor().equals(BACKGROUND_COLOR)) {
            stage.setBackgroundColor(ColorRGB.WHITE);
        } else {
            stage.setBackgroundColor(BACKGROUND_COLOR);
        }
    }

    private void causeError() {
        throw new RuntimeException("Intentional error");
    }

    @Override
    public void onError(SceneContext context, Exception cause) {
        Text errorText = new Text("Error:\n\n" + cause.getMessage(), this.font, Align.CENTER);
        errorText.setPosition(context.getCanvas().getCenter());
        context.getStage().getLayer("hud").add(errorText);
    }

    @Override
    public void update(SceneContext context, float deltaTime) {
        InputDevice inputDevice = context.getInput();
        this.handleClick(inputDevice, context.getStage());
        this.checkLogoClick(inputDevice);
        this.handleSystemControls(inputDevice);
        for (Mario mario : this.marios) {
            this.updateMario(mario, deltaTime);
        }
        List<String> info = context.getDebugInformation();
        info.add("Sprites:  " + this.marios.size());
        info.add("Keyboard:  " + inputDevice.isKeyboardAvailable());
        info.add("Touch:  " + inputDevice.isTouchAvailable());
        this.hud.setText(info);
    }

    private void updateMario(Mario mario, float deltaTime) {
        mario.update(deltaTime);
        mario.sprite.setPosition(mario.position);
        mario.sprite.setTransform(mario.mask ? MASK_TRANSFORM : null);
    }

    private void checkLogoClick(InputDevice input) {
        Rect area = new Rect(0.0f, (float)this.context.getCanvas().getHeight() - 80.0f, 80.0f, 80.0f);
        if (input.isPointerReleased(area)) {
            this.colorizeLogo.withLinkedGraphics(g -> {
                Transform transform;
                Sprite sprite = (Sprite)g;
                transform.setFlipHorizontal(!(transform = sprite.getTransform()).isFlipHorizontal());
            });
        }
    }

    private void handleClick(InputDevice inputDevice, Stage stage) {
        if (this.checkMarioClick(inputDevice)) {
            return;
        }
        if (inputDevice.isPointerReleased(stage.getCanvas().getBounds())) {
            this.createTouchMarker(inputDevice.getPointers());
        }
    }

    private boolean checkMarioClick(InputDevice inputDevice) {
        for (Mario mario : this.marios) {
            if (!inputDevice.isPointerReleased(mario.sprite.getBounds())) continue;
            mario.mask = !mario.mask;
            return true;
        }
        return false;
    }

    private void handleSystemControls(InputDevice input) {
        if (input.isKeyReleased(KeyCode.N9)) {
            ColorRGB background = this.context.getStage().getBackgroundColor().equals(BACKGROUND_COLOR) ? ColorRGB.WHITE : BACKGROUND_COLOR;
            this.context.getStage().setBackgroundColor(background);
        }
        if (input.isKeyReleased(KeyCode.F12)) {
            this.context.takeScreenshot();
        }
    }

    private void createTouchMarker(List<Point2D> positions) {
        for (Point2D position : positions) {
            Timeline timeline = new Timeline();
            timeline.addKeyFrame(0.0f, 100.0f);
            timeline.addKeyFrame(1.0f, 100.0f);
            timeline.addKeyFrame(1.5f, 0.0f);
            Text text = new Text(Math.round(position.getX()) + ", " + Math.round(position.getY()), this.font, Align.LEFT);
            text.setPosition(position);
            this.context.getStage().getLayer("hud").add(text);
            this.context.attach(Effect.forTextAlpha(text, timeline));
        }
    }

    public void addMarios(Stage stage) {
        int amount = this.marios.size() >= 100 ? 100 : 20;
        for (int i = 0; i < amount; ++i) {
            Sprite marioSprite = this.createMarioSprite();
            Mario mario = new Mario(marioSprite, new Rect(0.0f, 0.0f, this.context.getCanvas().getWidth(), this.context.getCanvas().getHeight()));
            this.marios.add(mario);
            this.updateMario(mario, 0.0f);
            stage.getDefaultLayer().add(marioSprite);
        }
    }

    private Sprite createMarioSprite() {
        Sprite marioSprite = new Sprite();
        for (String direction : DIRECTIONS) {
            List<Image> frames = this.marioSpriteSheet.get(List.of(direction + "_0", direction + "_1", direction + "_2", direction + "_3", direction + "_4"));
            Animation anim = new Animation(frames, 0.1f, true);
            marioSprite.addState(direction, anim);
        }
        return marioSprite;
    }

    private void removeMarios(int amount) {
        for (int i = 0; i < amount && !this.marios.isEmpty(); ++i) {
            Mario removed = this.marios.remove(this.marios.size() - 1);
            this.context.getStage().remove(removed.sprite);
        }
    }

    private static class Mario
    implements Updatable {
        private Sprite sprite;
        private Rect canvasBounds;
        private Point2D position;
        private int direction;
        private float speed;
        private boolean mask;

        public Mario(Sprite sprite, Rect canvasBounds) {
            this.sprite = sprite;
            this.position = new Point2D(RandomGenerator.getFloat(0.0f, canvasBounds.getWidth()), RandomGenerator.getFloat(0.0f, canvasBounds.getHeight()));
            this.canvasBounds = canvasBounds;
            this.direction = RandomGenerator.getInt(0, 4);
            this.speed = RandomGenerator.getFloat(20.0f, 80.0f);
            this.mask = false;
        }

        @Override
        public void update(float deltaTime) {
            this.sprite.changeState(DIRECTIONS.get(this.direction));
            this.sprite.update(deltaTime);
            switch (this.direction) {
                case 0: {
                    this.position.add(0.0f, -this.speed * deltaTime);
                    break;
                }
                case 1: {
                    this.position.add(this.speed * deltaTime, 0.0f);
                    break;
                }
                case 2: {
                    this.position.add(0.0f, this.speed * deltaTime);
                    break;
                }
                case 3: {
                    this.position.add(-this.speed * deltaTime, 0.0f);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            this.checkBounds();
        }

        private void checkBounds() {
            if (this.position.getX() < 0.0f || this.position.getX() > this.canvasBounds.getWidth() || this.position.getY() < 0.0f || this.position.getY() > this.canvasBounds.getHeight()) {
                this.direction = (this.direction + 2) % 4;
            }
        }
    }
}

