/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;

public abstract class Canvas {
    protected int screenWidth;
    protected int screenHeight;
    private int offsetX;
    private int offsetY;

    private Canvas(int preferredWidth, int preferredHeight) {
        Preconditions.checkArgument((preferredWidth > 0 ? 1 : 0) != 0, (Object)"Invalid width");
        Preconditions.checkArgument((preferredHeight > 0 ? 1 : 0) != 0, (Object)"Invalid height");
        this.screenWidth = preferredWidth;
        this.screenHeight = preferredHeight;
        this.offsetX = 0;
        this.offsetY = 0;
    }

    public void resizeScreen(int screenWidth, int screenHeight) {
        Preconditions.checkArgument((screenWidth > 0 && screenHeight > 0 ? 1 : 0) != 0, (Object)("Invalid screen dimensions: " + screenWidth + "x" + screenHeight));
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
    }

    public void offsetScreen(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public int getWidth() {
        return Math.round((float)this.screenWidth / this.getZoomLevel());
    }

    public int getHeight() {
        return Math.round((float)this.screenHeight / this.getZoomLevel());
    }

    public Rect getBounds() {
        return new Rect(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    public Point2D getCenter() {
        return new Point2D((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
    }

    public abstract float getZoomLevel();

    public float toCanvasX(int screenX) {
        return (float)(screenX - this.offsetX) / this.getZoomLevel();
    }

    public float toCanvasX(Point2D point) {
        return this.toCanvasX(Math.round(point.getX()));
    }

    public float toCanvasY(int screenY) {
        return (float)(screenY - this.offsetY) / this.getZoomLevel();
    }

    public float toCanvasY(Point2D point) {
        return this.toCanvasY(Math.round(point.getY()));
    }

    public float toScreenX(float canvasX) {
        return canvasX * this.getZoomLevel() + (float)this.offsetX;
    }

    public float toScreenX(Point2D point) {
        return this.toScreenX(point.getX());
    }

    public float toScreenY(float canvasY) {
        return canvasY * this.getZoomLevel() + (float)this.offsetY;
    }

    public float toScreenY(Point2D point) {
        return this.toScreenY(point.getY());
    }

    public String toString() {
        float zoomLevel = this.getZoomLevel();
        return this.getWidth() + "x" + this.getHeight() + " @ " + MathUtils.format(zoomLevel, 1) + "x";
    }

    public static Canvas flexible(int preferredWidth, int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight){

            @Override
            public float getZoomLevel() {
                return 1.0f;
            }
        };
    }

    public static Canvas scale(final int preferredWidth, final int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight){

            @Override
            public float getZoomLevel() {
                float horizontalZoom = (float)this.screenWidth / (float)preferredWidth;
                float verticalZoom = (float)this.screenHeight / (float)preferredHeight;
                return Math.max(horizontalZoom, verticalZoom);
            }
        };
    }

    public static Canvas fit(final int preferredWidth, final int preferredHeight) {
        return new Canvas(preferredWidth, preferredHeight){

            @Override
            public float getZoomLevel() {
                float horizontalZoom = (float)this.screenWidth / (float)preferredWidth;
                float verticalZoom = (float)this.screenHeight / (float)preferredHeight;
                return Math.min(horizontalZoom, verticalZoom);
            }
        };
    }
}

