/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.util.Stopwatch;

public class FrameStats {
    private DisplayMode displayMode;
    private Map<String, PhaseStats> stats;
    public static final String PHASE_FRAME_TIME = "$$frameTime";
    public static final String PHASE_FRAME_UPDATE = "$$frameUpdate";
    public static final String PHASE_FRAME_RENDER = "$$frameRender";
    private static final int SLIDING_WINDOW_FRAMES = 60;

    public FrameStats(DisplayMode displayMode) {
        this.displayMode = displayMode;
        this.stats = new LinkedHashMap<String, PhaseStats>();
    }

    private PhaseStats prepare(String phase) {
        PhaseStats phaseStats = this.stats.get(phase);
        if (phaseStats == null) {
            phaseStats = new PhaseStats(phase, new Stopwatch(), new LinkedList<Integer>());
            this.stats.put(phase, phaseStats);
        }
        return phaseStats;
    }

    public void markStart(String phase) {
        PhaseStats phaseStats = this.prepare(phase);
        phaseStats.timer.tick();
    }

    public void markEnd(String phase) {
        PhaseStats phaseStats = this.prepare(phase);
        long value = phaseStats.timer.tick();
        phaseStats.values.add((int)value);
        while (phaseStats.values.size() > 60) {
            phaseStats.values.removeFirst();
        }
    }

    public int getTargetFramerate() {
        return this.displayMode.framerate();
    }

    public int getActualFramerate() {
        int frameTimeMS = this.getAverageTimeMS(PHASE_FRAME_TIME);
        return 1000 / Math.max(frameTimeMS, 1);
    }

    public int getFrameUpdateTime() {
        return this.getAverageTimeMS(PHASE_FRAME_UPDATE);
    }

    public int getFrameRenderTime() {
        return this.getAverageTimeMS(PHASE_FRAME_RENDER);
    }

    public int getAverageTimeMS(String phase) {
        PhaseStats phaseStats = this.prepare(phase);
        return (int)MathUtils.average(phaseStats.values);
    }

    public List<String> getCustomStats() {
        return this.stats.keySet().stream().filter(phase -> !phase.startsWith("$$")).toList();
    }

    public List<Integer> getFrameTimes() {
        PhaseStats phaseStats = this.prepare(PHASE_FRAME_TIME);
        return List.copyOf(phaseStats.values);
    }

    private record PhaseStats(String phase, Stopwatch timer, LinkedList<Integer> values) {
    }
}

