/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.headless;

import com.google.common.annotations.VisibleForTesting;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.headless.HeadlessAudio;
import nl.colorize.multimedialib.renderer.headless.HeadlessFont;
import nl.colorize.multimedialib.renderer.headless.HeadlessImage;
import nl.colorize.multimedialib.renderer.java2d.StandardMediaLoader;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.OutlineFont;

@VisibleForTesting
public class HeadlessMediaLoader
extends StandardMediaLoader {
    private boolean graphicsEnvironmentEnabled;

    public HeadlessMediaLoader(boolean graphicsEnvironmentEnabled) {
        this.graphicsEnvironmentEnabled = graphicsEnvironmentEnabled;
    }

    @Override
    public Image loadImage(FilePointer file) {
        if (this.graphicsEnvironmentEnabled) {
            return super.loadImage(file);
        }
        if (file == null) {
            return new HeadlessImage();
        }
        return new HeadlessImage(file.path());
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        return new HeadlessAudio();
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        if (this.graphicsEnvironmentEnabled) {
            return super.loadFont(file, style);
        }
        return new HeadlessFont(style);
    }
}

