/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.java2d;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.reflect.ClassPath;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.renderer.headless.HeadlessAudio;
import nl.colorize.multimedialib.renderer.java2d.AWTFont;
import nl.colorize.multimedialib.renderer.java2d.AWTImage;
import nl.colorize.multimedialib.renderer.java2d.JavaSoundPlayer;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.ResourceFile;
import nl.colorize.util.swing.Utils2D;

public class StandardMediaLoader
implements MediaLoader {
    private Function<FilePointer, ResourceFile> locator;
    private Set<String> classPathResources;
    private static final Logger LOGGER = LogHelper.getLogger(StandardMediaLoader.class);

    public StandardMediaLoader() {
        this.locator = file -> new ResourceFile(file.path());
        this.classPathResources = Collections.emptySet();
        try {
            ClassLoader classLoader = StandardMediaLoader.class.getClassLoader();
            this.classPathResources = ClassPath.from((ClassLoader)classLoader).getResources().stream().map(resource -> resource.getResourceName()).collect(Collectors.toSet());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to preload classpath resources", e);
        }
    }

    @VisibleForTesting
    public StandardMediaLoader(File resourceDir) {
        Preconditions.checkArgument((resourceDir.exists() && resourceDir.isDirectory() ? 1 : 0) != 0, (Object)("Invalid resource directory: " + resourceDir.getAbsolutePath()));
        this.locator = file -> {
            File localFile = new File(resourceDir.getAbsolutePath() + "/" + file.path());
            return new ResourceFile(localFile);
        };
        this.classPathResources = Collections.emptySet();
    }

    @Override
    public Image loadImage(FilePointer file) {
        try {
            ResourceFile source = this.toResourceFile(file);
            BufferedImage loadedImage = Utils2D.loadImage((InputStream)source.openStream());
            return new AWTImage(loadedImage, file);
        }
        catch (IOException e) {
            throw new MediaException("Cannot load image from " + file.path(), e);
        }
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        if (Platform.isMac()) {
            return new JavaSoundPlayer(this.toResourceFile(file));
        }
        LOGGER.warning("Java Sound not supported on platform " + Platform.getPlatformName());
        return new HeadlessAudio();
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        OutlineFont outlineFont;
        block8: {
            ResourceFile source = this.toResourceFile(file);
            InputStream stream = source.openStream();
            try {
                Font font = Font.createFont(0, stream);
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                env.registerFont(font);
                outlineFont = new AWTFont(font, style).derive(style);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException e) {
                    throw new MediaException("Cannot load font from " + file.path(), e);
                }
            }
            stream.close();
        }
        return outlineFont;
    }

    @Override
    public String loadText(FilePointer file) {
        return this.toResourceFile(file).read(Charsets.UTF_8);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        if (this.classPathResources.isEmpty()) {
            return this.toResourceFile(file).exists();
        }
        return this.classPathResources.contains(file.path());
    }

    @Override
    public Optional<String> loadApplicationData(String appName, String fileName) {
        File file = Platform.getApplicationData((String)appName, (String)fileName);
        if (!file.exists()) {
            return Optional.empty();
        }
        try {
            String contents = Files.readString(file.toPath(), Charsets.UTF_8);
            return Optional.of(contents);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load application data", e);
            return Optional.empty();
        }
    }

    @Override
    public void saveApplicationData(String appName, String fileName, String data) {
        try {
            File file = Platform.getApplicationData((String)appName, (String)fileName);
            Files.writeString(file.toPath(), (CharSequence)data, Charsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MediaException("Unable to save application data", e);
        }
    }

    private ResourceFile toResourceFile(FilePointer file) {
        return this.locator.apply(file);
    }
}

