/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.audio.Sound;
import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.stage.Audio;

public class GDXAudio
implements Audio {
    private Sound sound;

    public GDXAudio(Sound sound) {
        this.sound = sound;
    }

    @Override
    public void play(int volume, boolean loop) {
        Preconditions.checkArgument((volume >= 0 && volume <= 100 ? 1 : 0) != 0, (Object)("Invalid volume: " + volume));
        this.sound.stop();
        if (loop) {
            this.sound.loop((float)volume / 100.0f);
        } else {
            this.sound.play((float)volume / 100.0f);
        }
    }

    @Override
    public void stop() {
        this.sound.stop();
    }
}

