/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.libgdx;

import com.badlogic.gdx.Gdx;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.KeyCode;
import nl.colorize.util.Platform;
import nl.colorize.util.swing.Popups;
import nl.colorize.util.swing.SwingUtils;

public class GDXInput
implements InputDevice {
    private Canvas canvas;
    private Point2D pointer;
    private boolean pointerPressed;
    private boolean pointerReleased;
    private Set<KeyCode> keysDown;
    private Set<KeyCode> keysUp;
    private static final Map<KeyCode, Integer> KEY_MAPPING = new ImmutableMap.Builder().put((Object)KeyCode.LEFT, (Object)21).put((Object)KeyCode.RIGHT, (Object)22).put((Object)KeyCode.UP, (Object)19).put((Object)KeyCode.DOWN, (Object)20).put((Object)KeyCode.ENTER, (Object)66).put((Object)KeyCode.SPACEBAR, (Object)62).put((Object)KeyCode.ESCAPE, (Object)111).put((Object)KeyCode.SHIFT, (Object)59).put((Object)KeyCode.BACKSPACE, (Object)67).put((Object)KeyCode.TAB, (Object)61).put((Object)KeyCode.A, (Object)29).put((Object)KeyCode.B, (Object)30).put((Object)KeyCode.C, (Object)31).put((Object)KeyCode.D, (Object)32).put((Object)KeyCode.E, (Object)33).put((Object)KeyCode.F, (Object)34).put((Object)KeyCode.G, (Object)35).put((Object)KeyCode.H, (Object)36).put((Object)KeyCode.I, (Object)37).put((Object)KeyCode.J, (Object)38).put((Object)KeyCode.K, (Object)39).put((Object)KeyCode.L, (Object)40).put((Object)KeyCode.M, (Object)41).put((Object)KeyCode.N, (Object)42).put((Object)KeyCode.O, (Object)43).put((Object)KeyCode.P, (Object)44).put((Object)KeyCode.Q, (Object)45).put((Object)KeyCode.R, (Object)46).put((Object)KeyCode.S, (Object)47).put((Object)KeyCode.T, (Object)48).put((Object)KeyCode.U, (Object)49).put((Object)KeyCode.V, (Object)50).put((Object)KeyCode.W, (Object)51).put((Object)KeyCode.X, (Object)52).put((Object)KeyCode.Y, (Object)53).put((Object)KeyCode.Z, (Object)54).put((Object)KeyCode.N1, (Object)8).put((Object)KeyCode.N2, (Object)9).put((Object)KeyCode.N3, (Object)10).put((Object)KeyCode.N4, (Object)11).put((Object)KeyCode.N5, (Object)12).put((Object)KeyCode.N6, (Object)13).put((Object)KeyCode.N7, (Object)14).put((Object)KeyCode.N8, (Object)15).put((Object)KeyCode.N9, (Object)16).put((Object)KeyCode.N0, (Object)7).put((Object)KeyCode.F1, (Object)131).put((Object)KeyCode.F2, (Object)132).put((Object)KeyCode.F3, (Object)133).put((Object)KeyCode.F4, (Object)134).put((Object)KeyCode.F5, (Object)135).put((Object)KeyCode.F6, (Object)136).put((Object)KeyCode.F7, (Object)137).put((Object)KeyCode.F8, (Object)138).put((Object)KeyCode.F9, (Object)139).put((Object)KeyCode.F10, (Object)140).put((Object)KeyCode.F11, (Object)141).put((Object)KeyCode.F12, (Object)142).build();

    protected GDXInput(Canvas canvas) {
        this.canvas = canvas;
        this.pointer = new Point2D(0.0f, 0.0f);
        this.pointerPressed = false;
        this.pointerReleased = false;
        this.keysUp = new HashSet<KeyCode>();
        this.keysDown = new HashSet<KeyCode>();
    }

    @Override
    public void update(float deltaTime) {
        this.updatePointer();
        this.updateKeyboard();
    }

    private void updatePointer() {
        this.pointer.set(this.canvas.toCanvasX(Gdx.input.getX()), this.canvas.toCanvasY(Gdx.input.getY()));
        if (Gdx.input.isTouched()) {
            this.pointerPressed = true;
            this.pointerReleased = false;
        } else if (this.pointerPressed) {
            this.pointerPressed = false;
            this.pointerReleased = true;
        } else {
            this.pointerPressed = false;
            this.pointerReleased = false;
        }
    }

    private void updateKeyboard() {
        for (KeyCode keyCode : KeyCode.values()) {
            Integer gdxKeyCode = KEY_MAPPING.get((Object)keyCode);
            if (Gdx.input.isKeyPressed(gdxKeyCode.intValue())) {
                this.keysDown.add(keyCode);
                this.keysUp.remove((Object)keyCode);
                continue;
            }
            if (this.keysDown.contains((Object)keyCode)) {
                this.keysDown.remove((Object)keyCode);
                this.keysUp.add(keyCode);
                continue;
            }
            this.keysDown.remove((Object)keyCode);
            this.keysUp.remove((Object)keyCode);
        }
    }

    @Override
    public List<Point2D> getPointers() {
        return ImmutableList.of((Object)this.pointer.copy());
    }

    @Override
    public boolean isPointerPressed(Rect area) {
        return this.pointerPressed && area.contains(this.pointer);
    }

    @Override
    public boolean isPointerReleased(Rect area) {
        return this.pointerReleased && area.contains(this.pointer);
    }

    @Override
    public boolean isPointerReleased() {
        return this.pointerReleased;
    }

    @Override
    public void clearPointerReleased() {
        this.pointerReleased = false;
    }

    @Override
    public boolean isTouchAvailable() {
        Platform platform = Platform.getPlatform();
        return platform == Platform.IOS || platform == Platform.ANDROID;
    }

    @Override
    public boolean isKeyboardAvailable() {
        return !this.isTouchAvailable();
    }

    @Override
    public boolean isKeyPressed(KeyCode keyCode) {
        return this.keysDown.contains((Object)keyCode);
    }

    @Override
    public boolean isKeyReleased(KeyCode keyCode) {
        return this.keysUp.contains((Object)keyCode);
    }

    @Override
    public String requestTextInput(String labelText, String initialValue) {
        JLabel label = new JLabel(labelText);
        JTextField field = new JTextField(initialValue);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)label, "North");
        panel.add((Component)field, "Center");
        SwingUtils.setPreferredWidth((JComponent)panel, (int)300);
        Popups.message(null, (String)"", (JComponent)panel);
        return field.getText();
    }
}

