/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.pixi;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.pixi.Pixi;
import nl.colorize.multimedialib.renderer.pixi.PixiInterface;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Layer2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageObserver;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import nl.colorize.util.LogHelper;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.dom.html.HTMLCanvasElement;

public class PixiGraphics
implements TeaGraphics,
StageObserver {
    private Canvas canvas;
    private BrowserDOM dom;
    private PixiInterface pixi;
    private Map<Graphic2D, Pixi.DisplayObject> displayObjects;
    private Graphic2D currentGraphic;
    private Pixi.DisplayObject currentDisplayObject;
    private int zIndex;
    private static final Logger LOGGER = LogHelper.getLogger(PixiGraphics.class);

    public PixiGraphics(Canvas canvas) {
        this.canvas = canvas;
        this.dom = new BrowserDOM();
        this.pixi = Browser.getPixiInterface();
        this.displayObjects = new HashMap<Graphic2D, Pixi.DisplayObject>();
    }

    @Override
    public void init() {
        this.pixi.init();
        this.pixi.createLayer("$$default");
    }

    private Pixi.Rectangle getScreen() {
        return this.pixi.getPixiApp().getScreen();
    }

    @Override
    public int getDisplayWidth() {
        return Math.round(this.getScreen().getWidth());
    }

    @Override
    public int getDisplayHeight() {
        return Math.round(this.getScreen().getHeight());
    }

    @Override
    public float getDevicePixelRatio() {
        return 1.0f;
    }

    @Override
    public void preVisitStage(Stage stage) {
        this.currentGraphic = null;
        this.zIndex = 1;
    }

    @Override
    public void prepareLayer(Layer2D layer) {
    }

    @Override
    public void preVisitGraphic(Graphic2D graphic, boolean visible) {
        this.currentGraphic = graphic;
        this.currentDisplayObject = this.displayObjects.get(this.currentGraphic);
        if (this.currentDisplayObject == null) {
            LOGGER.warning("No display object for " + graphic);
        }
        this.currentDisplayObject.setVisible(visible);
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.pixi.changeBackgroundColor(color.getRGB());
    }

    @Override
    public void drawSprite(Sprite sprite) {
        Pixi.DisplayObject[] containerContents = this.currentDisplayObject.getChildren();
        if (containerContents.length == 0) {
            return;
        }
        Pixi.DisplayObject spriteDisplayObject = containerContents[0];
        TeaImage image = this.getImage(sprite);
        Transform transform = sprite.getTransform();
        float zoom = this.canvas.getZoomLevel();
        spriteDisplayObject.setX(this.toScreenX(sprite.getPosition()));
        spriteDisplayObject.setY(this.toScreenY(sprite.getPosition()));
        spriteDisplayObject.setAlpha(transform.getAlpha() / 100.0f);
        spriteDisplayObject.setAngle(transform.getRotation());
        spriteDisplayObject.getScale().setX(transform.getScaleX() * zoom / 100.0f);
        spriteDisplayObject.getScale().setY(transform.getScaleY() * zoom / 100.0f);
        this.selectTexture(spriteDisplayObject, image, transform.getMask());
        this.updateTexture(spriteDisplayObject, image.getRegion());
    }

    private void updateTexture(Pixi.DisplayObject sprite, Region region) {
        Pixi.Texture texture = sprite.getTexture();
        texture.getFrame().setX(region.x());
        texture.getFrame().setY(region.y());
        texture.getFrame().setWidth(region.width());
        texture.getFrame().setHeight(region.height());
        texture.updateUvs();
    }

    private void selectTexture(Pixi.DisplayObject sprite, TeaImage image, ColorRGB mask) {
        if (!sprite.isTintEnabled() && mask != null) {
            HTMLCanvasElement maskImage = this.dom.applyMask(image, mask);
            Region region = image.getRegion();
            Pixi.Texture maskTexture = this.pixi.createTexture((CanvasImageSource)maskImage, region.x(), region.y(), region.width(), region.height());
            sprite.setTintEnabled(true);
            sprite.setTexture(maskTexture);
        } else if (sprite.isTintEnabled() && mask == null) {
            sprite.setTintEnabled(false);
            sprite.setTexture(sprite.getOriginalTexture());
        }
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        this.currentDisplayObject.clear();
        this.currentDisplayObject.lineStyle(line.getThickness(), graphic.getColor().getRGB());
        this.currentDisplayObject.moveTo(this.toScreenX(line.getStart()), this.toScreenY(line.getStart()));
        this.currentDisplayObject.lineTo(this.toScreenX(line.getEnd()), this.toScreenY(line.getEnd()));
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        this.currentDisplayObject.clear();
        this.currentDisplayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        this.currentDisplayObject.drawRect(this.toScreenX(rect.getX()), this.toScreenY(rect.getY()), rect.getWidth() * this.canvas.getZoomLevel(), rect.getHeight() * this.canvas.getZoomLevel());
        this.currentDisplayObject.endFill();
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        this.currentDisplayObject.clear();
        this.currentDisplayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        this.currentDisplayObject.drawCircle(this.toScreenX(circle.getCenterX()), this.toScreenY(circle.getCenterY()), circle.getRadius() * this.canvas.getZoomLevel());
        this.currentDisplayObject.endFill();
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        float[] points = new float[polygon.getNumPoints() * 2];
        for (int i = 0; i < polygon.getNumPoints(); ++i) {
            points[i * 2] = this.toScreenX(polygon.getPointX(i));
            points[i * 2 + 1] = this.toScreenY(polygon.getPointY(i));
        }
        this.currentDisplayObject.clear();
        this.currentDisplayObject.beginFill(graphic.getColor().getRGB(), 1.0f);
        this.currentDisplayObject.drawPolygon(points);
        this.currentDisplayObject.endFill();
        this.currentDisplayObject.setAlpha(graphic.getAlpha() / 100.0f);
    }

    @Override
    public void drawText(Text text) {
        float offset = -0.4f * text.getLineHeight();
        this.currentDisplayObject.setText(text.getText());
        this.currentDisplayObject.setX(this.toScreenX(text.getPosition()));
        this.currentDisplayObject.setY(this.toScreenY(text.getPosition().getY() + offset));
        this.currentDisplayObject.setAlpha(text.getAlpha() / 100.0f);
    }

    private float toScreenX(float x) {
        return this.canvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.canvas.toScreenX(point.getX());
    }

    private float toScreenY(float y) {
        return this.canvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.canvas.toScreenY(point.getY());
    }

    @Override
    public void onLayerAdded(Layer2D layer) {
        this.pixi.createLayer(layer.getName());
    }

    @Override
    public void onGraphicAdded(Layer2D layer, Graphic2D graphic) {
        ++this.zIndex;
        Pixi.DisplayObject displayObject = this.createDisplayObject(graphic);
        displayObject.setZIndex(this.zIndex);
        this.pixi.addDisplayObject(layer.getName(), displayObject);
        this.displayObjects.put(graphic, displayObject);
    }

    private Pixi.DisplayObject createDisplayObject(Graphic2D graphic) {
        if (graphic instanceof Sprite) {
            Sprite sprite = (Sprite)graphic;
            return this.createSpriteDisplayObject(sprite);
        }
        if (graphic instanceof Primitive) {
            return this.pixi.createGraphics();
        }
        if (graphic instanceof Text) {
            Text text = (Text)graphic;
            return this.createTextDisplayObject(text);
        }
        throw new IllegalArgumentException("Unknown graphics type: " + graphic);
    }

    private Pixi.DisplayObject createSpriteDisplayObject(Sprite sprite) {
        TeaImage image = this.getImage(sprite);
        Pixi.DisplayObject spriteContainer = this.pixi.createContainer();
        image.getImagePromise().then(img -> {
            Region region = image.getRegion();
            Pixi.Texture texture = this.pixi.createTexture((CanvasImageSource)img, region.x(), region.y(), region.width(), region.height());
            Pixi.DisplayObject spriteDisplayObject = this.pixi.createSprite(texture);
            spriteContainer.addChild(spriteDisplayObject);
        });
        return spriteContainer;
    }

    private Pixi.DisplayObject createTextDisplayObject(Text text) {
        FontStyle style = text.getFont().scale(this.canvas).getStyle();
        return this.pixi.createText(style.family(), style.size(), style.bold(), text.getAlign().toString(), text.getLineHeight(), style.color().getRGB());
    }

    private TeaImage getImage(Sprite sprite) {
        return (TeaImage)sprite.getCurrentGraphics();
    }

    @Override
    public void onGraphicRemoved(Layer2D layer, Graphic2D graphic) {
        Pixi.DisplayObject displayObject = this.displayObjects.get(graphic);
        if (displayObject != null) {
            this.pixi.removeDisplayObject(layer.getName(), displayObject);
        }
    }

    @Override
    public void onStageCleared() {
        this.pixi.clearStage();
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }
}

