/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.util.stats.Cache;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLImageElement;

public class BrowserDOM {
    private Cache<MaskImage, HTMLCanvasElement> maskImageCache = Cache.from(this::createMaskImage, (int)500);
    private static final int IMAGE_CACHE_SIZE = 500;

    public HTMLCanvasElement applyMask(TeaImage image, ColorRGB mask) {
        MaskImage cacheKey = new MaskImage(image, mask);
        return (HTMLCanvasElement)this.maskImageCache.get((Object)cacheKey);
    }

    private HTMLCanvasElement createMaskImage(MaskImage key) {
        Preconditions.checkState((boolean)key.image.isLoaded(), (Object)"Image is still loading");
        HTMLDocument document = Window.current().getDocument();
        HTMLImageElement img = key.image().getImageElement().get();
        HTMLCanvasElement canvas = (HTMLCanvasElement)document.createElement("canvas");
        canvas.setWidth(img.getWidth());
        canvas.setHeight(img.getHeight());
        CanvasRenderingContext2D maskContext = (CanvasRenderingContext2D)canvas.getContext("2d");
        maskContext.drawImage((CanvasImageSource)img, 0.0, 0.0, (double)img.getWidth(), (double)img.getHeight());
        maskContext.setGlobalCompositeOperation("source-atop");
        maskContext.setFillStyle(key.mask().toHex());
        maskContext.fillRect(0.0, 0.0, (double)img.getWidth(), (double)img.getHeight());
        return canvas;
    }

    private record MaskImage(TeaImage image, ColorRGB mask) {
    }
}

