/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import nl.colorize.multimedialib.math.Circle;
import nl.colorize.multimedialib.math.Line;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Polygon;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Region;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.BrowserDOM;
import nl.colorize.multimedialib.renderer.teavm.TeaGraphics;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.stage.ColorRGB;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.multimedialib.stage.Transform;
import org.teavm.jso.browser.Window;
import org.teavm.jso.canvas.CanvasImageSource;
import org.teavm.jso.canvas.CanvasRenderingContext2D;
import org.teavm.jso.dom.html.HTMLCanvasElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.xml.Node;

public class HtmlCanvasGraphics
implements TeaGraphics {
    private Canvas sceneCanvas;
    private BrowserDOM dom;
    private HTMLCanvasElement htmlCanvas;
    private CanvasRenderingContext2D context;
    private static final String QUERY_STRING = Browser.getPageQueryString();
    private static final boolean BOUNDS_TRACING_ENABLED = QUERY_STRING.contains("bounds-tracing");

    public HtmlCanvasGraphics(Canvas sceneCanvas) {
        this.sceneCanvas = sceneCanvas;
        this.dom = new BrowserDOM();
    }

    @Override
    public void init() {
        Window window = Window.current();
        HTMLDocument document = window.getDocument();
        this.htmlCanvas = (HTMLCanvasElement)document.createElement("canvas");
        this.context = (CanvasRenderingContext2D)this.htmlCanvas.getContext("2d");
        HTMLElement container = document.getElementById("multimediaLibContainer");
        container.appendChild((Node)this.htmlCanvas);
        this.resizeCanvas(document, container);
        window.addEventListener("resize", e -> this.resizeCanvas(document, container));
    }

    private void resizeCanvas(HTMLDocument document, HTMLElement container) {
        int width = Math.round(container.getOffsetWidth());
        int height = Math.round(document.getDocumentElement().getClientHeight());
        this.htmlCanvas.getStyle().setProperty("width", width + "px");
        this.htmlCanvas.getStyle().setProperty("height", height + "px");
        this.htmlCanvas.setWidth(Math.round((float)width * this.getDevicePixelRatio()));
        this.htmlCanvas.setHeight(Math.round((float)height * this.getDevicePixelRatio()));
    }

    @Override
    public int getDisplayWidth() {
        return this.htmlCanvas.getWidth();
    }

    @Override
    public int getDisplayHeight() {
        return this.htmlCanvas.getHeight();
    }

    @Override
    public void drawBackground(ColorRGB color) {
        this.context.clearRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
        this.context.setFillStyle(color.toHex());
        this.context.fillRect(0.0, 0.0, (double)this.htmlCanvas.getWidth(), (double)this.htmlCanvas.getHeight());
    }

    @Override
    public void drawSprite(Sprite sprite) {
        TeaImage teaImage = (TeaImage)sprite.getCurrentGraphics();
        if ((float)teaImage.getWidth() > 0.0f && (float)teaImage.getHeight() > 0.0f) {
            this.drawImage(teaImage, teaImage.getRegion(), sprite.getPosition(), sprite.getTransform());
            if (BOUNDS_TRACING_ENABLED) {
                this.drawRect(sprite.getBounds(), ColorRGB.RED, 50.0f);
            }
        }
    }

    private void drawImage(TeaImage image, Region region, Point2D position, Transform transform) {
        CanvasImageSource source = this.prepareImage(image, transform.getMask());
        if (source == null) {
            return;
        }
        this.context.setGlobalAlpha((double)(transform.getAlpha() / 100.0f));
        this.context.translate((double)this.toScreenX(position), (double)this.toScreenY(position));
        this.context.rotate((double)transform.getRotation() * Math.PI / 180.0);
        this.context.scale((double)(transform.getScaleX() * this.sceneCanvas.getZoomLevel() / 100.0f), (double)(transform.getScaleY() * this.sceneCanvas.getZoomLevel() / 100.0f));
        this.context.drawImage(source, (double)region.x(), (double)region.y(), (double)region.width(), (double)region.height(), (double)((float)(-region.width()) / 2.0f), (double)((float)(-region.height()) / 2.0f), (double)region.width(), (double)region.height());
        this.context.setGlobalAlpha(1.0);
        this.context.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    }

    private CanvasImageSource prepareImage(TeaImage image, ColorRGB mask) {
        if (!image.isLoaded()) {
            return null;
        }
        if (mask == null) {
            return image.getImageElement().orElse(null);
        }
        return this.dom.applyMask(image, mask);
    }

    @Override
    public void drawLine(Primitive graphic, Line line) {
        this.context.setStrokeStyle(graphic.getColor().toHex());
        this.context.setLineWidth((double)line.getThickness());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(line.getStart()), (double)this.toScreenY(line.getStart()));
        this.context.lineTo((double)this.toScreenX(line.getEnd()), (double)this.toScreenY(line.getEnd()));
        this.context.stroke();
    }

    @Override
    public void drawRect(Primitive graphic, Rect rect) {
        this.drawRect(rect, graphic.getColor(), graphic.getAlpha());
    }

    private void drawRect(Rect rect, ColorRGB color, float alpha) {
        this.context.setGlobalAlpha((double)(alpha / 100.0f));
        this.context.setFillStyle(color.toHex());
        this.context.fillRect((double)this.toScreenX(rect.getX()), (double)this.toScreenY(rect.getY()), (double)(rect.getWidth() * this.sceneCanvas.getZoomLevel()), (double)(rect.getHeight() * this.sceneCanvas.getZoomLevel()));
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawCircle(Primitive graphic, Circle circle) {
        this.context.setGlobalAlpha((double)(graphic.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.arc((double)this.toScreenX(circle.getCenterX()), (double)this.toScreenY(circle.getCenterY()), (double)(circle.getRadius() * this.sceneCanvas.getZoomLevel()), 0.0, Math.PI * 2);
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawPolygon(Primitive graphic, Polygon polygon) {
        this.context.setGlobalAlpha((double)(graphic.getAlpha() / 100.0f));
        this.context.setFillStyle(graphic.getColor().toHex());
        this.context.beginPath();
        this.context.moveTo((double)this.toScreenX(polygon.getPointX(0)), (double)this.toScreenY(polygon.getPointY(0)));
        for (int i = 1; i < polygon.getNumPoints(); ++i) {
            this.context.lineTo((double)this.toScreenX(polygon.getPointX(i)), (double)this.toScreenY(polygon.getPointY(i)));
        }
        this.context.fill();
        this.context.setGlobalAlpha(1.0);
    }

    @Override
    public void drawText(Text text) {
        FontStyle style = text.getFont().scale(this.sceneCanvas).getStyle();
        this.drawText(text, style);
    }

    private void drawText(Text text, FontStyle style) {
        float lineHeight = text.getFont() != null ? text.getLineHeight() : (float)style.size();
        this.changeCanvasFont(style);
        this.context.setGlobalAlpha((double)(text.getAlpha() / 100.0f));
        this.context.setFillStyle(style.color().toHex());
        this.context.setTextAlign(text.getAlign().toString().toLowerCase());
        text.forLines((i, line) -> {
            float y = this.toScreenY(text.getPosition().getY() + (float)i.intValue() * lineHeight);
            this.context.fillText(line, (double)this.toScreenX(text.getPosition()), (double)y);
        });
        this.context.setGlobalAlpha(1.0);
    }

    private void changeCanvasFont(FontStyle style) {
        String fontStyle = style.bold() ? "bold " : "";
        String fontString = fontStyle + style.size() + "px " + style.family();
        if (!this.context.getFont().equals(fontString)) {
            this.context.setFont(fontString);
        }
    }

    private float toScreenX(float x) {
        return this.sceneCanvas.toScreenX(x);
    }

    private float toScreenX(Point2D point) {
        return this.sceneCanvas.toScreenX(point.getX());
    }

    private float toScreenY(float y) {
        return this.sceneCanvas.toScreenY(y);
    }

    private float toScreenY(Point2D point) {
        return this.sceneCanvas.toScreenY(point.getY());
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return GraphicsMode.MODE_2D;
    }
}

