/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.renderer.teavm;

import com.google.common.base.Splitter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import nl.colorize.multimedialib.renderer.FilePointer;
import nl.colorize.multimedialib.renderer.GeometryBuilder;
import nl.colorize.multimedialib.renderer.MediaException;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.UnsupportedGraphicsModeException;
import nl.colorize.multimedialib.renderer.teavm.Browser;
import nl.colorize.multimedialib.renderer.teavm.TeaAudio;
import nl.colorize.multimedialib.renderer.teavm.TeaFont;
import nl.colorize.multimedialib.renderer.teavm.TeaImage;
import nl.colorize.multimedialib.renderer.three.ThreeGraphics;
import nl.colorize.multimedialib.stage.Audio;
import nl.colorize.multimedialib.stage.FontStyle;
import nl.colorize.multimedialib.stage.Image;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.multimedialib.stage.PolygonModel;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.Promise;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.html.HTMLAudioElement;
import org.teavm.jso.dom.html.HTMLDocument;
import org.teavm.jso.dom.html.HTMLElement;
import org.teavm.jso.dom.html.HTMLImageElement;
import org.teavm.jso.dom.xml.Node;

public class TeaMediaLoader
implements MediaLoader {
    private HTMLDocument document = Window.current().getDocument();
    private StageVisitor graphics;
    private List<FilePointer> manifest;
    private static final FilePointer MANIFEST_FILE = new FilePointer("resource-file-manifest");
    private static final Splitter LINE_SPLITTER = Splitter.on((String)"\n").trimResults().omitEmptyStrings();

    protected TeaMediaLoader(StageVisitor graphics) {
        this.graphics = graphics;
        this.manifest = Collections.emptyList();
    }

    @Override
    public Image loadImage(FilePointer file) {
        HTMLImageElement imageElement = (HTMLImageElement)this.document.createElement("img");
        Promise imagePromise = new Promise();
        imageElement.addEventListener("load", event -> imagePromise.resolve((Object)imageElement));
        imageElement.setSrc("resources/" + this.normalizeFilePath(file, false));
        return new TeaImage((Promise<HTMLImageElement>)imagePromise, null);
    }

    @Override
    public Audio loadAudio(FilePointer file) {
        HTMLAudioElement audioElement = (HTMLAudioElement)this.document.createElement("audio");
        Promise audioPromise = new Promise();
        audioElement.addEventListener("loadeddata", event -> audioPromise.resolve((Object)audioElement));
        audioElement.setSrc("resources/" + this.normalizeFilePath(file, false));
        return new TeaAudio((Promise<HTMLAudioElement>)audioPromise);
    }

    @Override
    public OutlineFont loadFont(FilePointer file, FontStyle style) {
        Object css = "";
        css = (String)css + "@font-face {\n";
        css = (String)css + "    font-family: '" + style.family() + "';\n";
        css = (String)css + "    font-style: normal;\n";
        css = (String)css + "    font-weight: 400;\n";
        css = (String)css + "    src: url('resources/" + this.normalizeFilePath(file, false) + "') format('truetype');\n";
        css = (String)css + "};\n";
        HTMLElement styleElement = this.document.createElement("style");
        styleElement.appendChild((Node)this.document.createTextNode((String)css));
        HTMLElement fontContainer = this.document.getElementById("fontContainer");
        fontContainer.appendChild((Node)styleElement);
        return new TeaFont(style);
    }

    @Override
    public PolygonModel loadModel(FilePointer file) {
        if (!(this.graphics instanceof ThreeGraphics)) {
            throw new UnsupportedGraphicsModeException();
        }
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public GeometryBuilder getGeometryBuilder() {
        if (!(this.graphics instanceof ThreeGraphics)) {
            throw new UnsupportedGraphicsModeException();
        }
        throw new UnsupportedGraphicsModeException();
    }

    @Override
    public String loadText(FilePointer file) {
        HTMLElement resource = this.document.getElementById(this.normalizeFilePath(file, true));
        if (resource == null) {
            throw new MediaException("Unknown text resource file: " + file);
        }
        return resource.getInnerText().trim();
    }

    @Override
    public boolean containsResourceFile(FilePointer file) {
        String fileEntry = file.path().contains("/") ? file.path().substring(file.path().lastIndexOf("/") + 1) : file.path();
        return this.loadResourceFileManifest().stream().anyMatch(entry -> entry.path().equals(fileEntry));
    }

    private List<FilePointer> loadResourceFileManifest() {
        if (!this.manifest.isEmpty()) {
            return this.manifest;
        }
        this.manifest = LINE_SPLITTER.splitToList((CharSequence)this.loadText(MANIFEST_FILE)).stream().map(path -> new FilePointer((String)path)).collect(Collectors.toList());
        return this.manifest;
    }

    protected String normalizeFilePath(FilePointer file, boolean replaceDot) {
        String normalized = file.path();
        if (normalized.indexOf(47) != -1) {
            normalized = normalized.substring(normalized.lastIndexOf(47) + 1);
        }
        if (replaceDot) {
            normalized = normalized.replace(".", "_");
        }
        return normalized;
    }

    @Override
    public Optional<String> loadApplicationData(String appName, String fileName) {
        String value = Browser.getLocalStorage(appName + "." + fileName);
        return Optional.ofNullable(value);
    }

    @Override
    public void saveApplicationData(String appName, String fileName, String data) {
        Browser.setLocalStorage(appName + "." + fileName, data);
    }
}

