/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Group;
import nl.colorize.multimedialib.stage.Layer2D;
import nl.colorize.multimedialib.stage.Primitive;
import nl.colorize.multimedialib.stage.Sprite;
import nl.colorize.multimedialib.stage.Text;
import nl.colorize.util.animation.Interpolation;
import nl.colorize.util.animation.Timeline;

public class Effect
implements Scene {
    private List<Runnable> startHandlers = new ArrayList<Runnable>();
    private List<Updatable> frameHandlers = new ArrayList<Updatable>();
    private List<Consumer<SceneContext>> clickHandlers = new ArrayList<Consumer<SceneContext>>();
    private List<Runnable> completionHandlers = new ArrayList<Runnable>();
    private List<Graphic2D> linkedGraphics = new ArrayList<Graphic2D>();
    private boolean completed = false;
    private SceneContext effectContext;
    public static final String EFFECT_LAYER_NAME = "$$Effect";
    public static final int EFFECT_LAYER_Z_INDEX = 1000;

    public void addStartHandler(Runnable handler) {
        this.startHandlers.add(handler);
    }

    public void addFrameHandler(Updatable handler) {
        this.frameHandlers.add(handler);
    }

    public void addClickHandler(Rect bounds, Runnable handler) {
        this.clickHandlers.add(context -> {
            InputDevice input = context.getInput();
            if (input.isPointerReleased(bounds)) {
                handler.run();
                input.clearPointerReleased();
            }
        });
    }

    public void addClickHandler(Graphic2D graphic, Runnable handler) {
        this.addClickHandler(graphic.getBounds(), handler);
    }

    public void addClickHandler(Group group, Runnable handler) {
        this.addClickHandler(group.getBounds(), handler);
    }

    public void addCompletionHandler(Runnable handler) {
        this.completionHandlers.add(handler);
    }

    public void addTimelineHandler(Timeline timeline, Consumer<Float> callback) {
        this.addFrameHandler(deltaTime -> {
            timeline.movePlayhead(deltaTime);
            callback.accept(Float.valueOf(timeline.getValue()));
            if (timeline.isCompleted() && !timeline.isLoop()) {
                this.complete();
            }
        });
    }

    public void stopAfter(float duration) {
        Timer timer = new Timer(duration);
        this.addFrameHandler(deltaTime -> {
            timer.update(deltaTime);
            if (timer.isCompleted()) {
                this.complete();
            }
        });
    }

    public void stopIf(Supplier<Boolean> condition) {
        this.addFrameHandler(deltaTime -> {
            if (((Boolean)condition.get()).booleanValue()) {
                this.complete();
            }
        });
    }

    public void removeAfterwards(Graphic2D ... graphics) {
        for (Graphic2D graphic : graphics) {
            this.linkedGraphics.add(graphic);
        }
    }

    public void removeAfterwards(Group group) {
        for (Graphic2D graphic : group) {
            this.linkedGraphics.add(graphic);
        }
    }

    @Override
    public final void start(SceneContext context) {
        this.effectContext = context;
        this.startHandlers.forEach(Runnable::run);
    }

    @Override
    public final void update(SceneContext context, float deltaTime) {
        this.effectContext = context;
        if (!this.completed) {
            this.frameHandlers.forEach(handler -> handler.update(deltaTime));
            this.clickHandlers.forEach(handler -> handler.accept(context));
        }
    }

    @Override
    public final void end(SceneContext context) {
        this.linkedGraphics.forEach(graphic -> context.getStage().remove((Graphic2D)graphic));
        this.completionHandlers.forEach(Runnable::run);
        this.effectContext = null;
    }

    public void complete() {
        this.completed = true;
    }

    @Override
    public final boolean isCompleted() {
        return this.completed;
    }

    public void withLinkedGraphics(Consumer<Graphic2D> callback) {
        this.linkedGraphics.forEach(callback);
    }

    public <T extends Graphic2D> void withLinkedGraphics(Class<T> type, Consumer<T> callback) {
        this.linkedGraphics.stream().filter(graphic -> graphic.getClass().equals(type)).forEach(graphic -> callback.accept(graphic));
    }

    protected SceneContext getContext() {
        Preconditions.checkState((this.effectContext != null ? 1 : 0) != 0, (Object)"Effect is inactive");
        return this.effectContext;
    }

    protected Layer2D getEffectLayer() {
        return this.getContext().getStage().addLayer(EFFECT_LAYER_NAME, 1000);
    }

    public static Effect forTimer(float duration) {
        return Effect.forTimer(duration, null);
    }

    public static Effect forTimer(float duration, Runnable action) {
        Effect effect = new Effect();
        Timer timer = new Timer(duration);
        if (action != null) {
            effect.addCompletionHandler(action);
        }
        effect.addFrameHandler(deltaTime -> {
            timer.update(deltaTime);
            if (timer.isCompleted()) {
                effect.complete();
            }
        });
        return effect;
    }

    public static Effect forTimeline(Timeline timeline, Consumer<Float> callback) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, callback);
        return effect;
    }

    public static Effect forSpriteX(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getPosition().setX(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forSpriteY(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getPosition().setY(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forSpriteRotation(Sprite sprite, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        Timeline timeline = new Timeline(Interpolation.LINEAR, true);
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, 360.0f);
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getTransform().setRotation(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forSpriteScale(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getTransform().setScale(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forSpriteAlpha(Sprite sprite, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> sprite.getTransform().setAlpha(value.floatValue()));
        effect.removeAfterwards(sprite);
        return effect;
    }

    public static Effect forPrimitiveAlpha(Primitive primitive, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> primitive.setAlpha(value.floatValue()));
        effect.removeAfterwards(primitive);
        return effect;
    }

    public static Effect forTextAlpha(Text text, Timeline timeline) {
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, value -> text.setAlpha(value.floatValue()));
        effect.removeAfterwards(text);
        return effect;
    }

    public static Effect forTextAppear(Text text, float duration) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid duration: " + duration));
        String originalText = text.getText();
        Timeline timeline = new Timeline();
        timeline.addKeyFrame(0.0f, 0.0f);
        timeline.addKeyFrame(duration, (float)originalText.length());
        Effect effect = new Effect();
        effect.addTimelineHandler(timeline, deltaTime -> {
            String visibleText = originalText.substring(0, (int)timeline.getValue());
            text.setText(visibleText);
        });
        return effect;
    }
}

