/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.scene.Effect;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.Layer2D;

public class OrientationLockScreen
extends Effect {
    private boolean active;
    private List<Graphic2D> graphics;

    public OrientationLockScreen(Graphic2D ... graphics) {
        Preconditions.checkArgument((graphics.length > 0 ? 1 : 0) != 0, (Object)"Orientation lock screen must have graphics");
        this.active = false;
        this.graphics = ImmutableList.copyOf((Object[])graphics);
        this.addFrameHandler(this::update);
    }

    private void update(float deltaTime) {
        Canvas canvas = this.getContext().getCanvas();
        Layer2D layer = this.getEffectLayer();
        if (this.active && !this.shouldBeActive(canvas)) {
            this.graphics.forEach(layer::remove);
            this.active = false;
        } else if (!this.active && this.shouldBeActive(canvas)) {
            this.graphics.forEach(xva$0 -> layer.add((Graphic2D)xva$0));
            this.active = true;
        }
        if (this.active) {
            for (Graphic2D graphic : this.graphics) {
                graphic.setPosition(canvas.getCenter());
            }
        }
    }

    private boolean shouldBeActive(Canvas canvas) {
        return canvas.getWidth() < canvas.getHeight();
    }
}

