/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.scene.SceneContext;
import nl.colorize.multimedialib.scene.Timer;
import nl.colorize.multimedialib.scene.Updatable;

@FunctionalInterface
public interface Scene {
    default public void start(SceneContext context) {
    }

    public void update(SceneContext var1, float var2);

    default public void end(SceneContext context) {
    }

    default public boolean isCompleted() {
        return false;
    }

    public static Scene wrap(Updatable callback) {
        return (context, deltaTime) -> callback.update(deltaTime);
    }

    public static Scene delay(float duration, final Runnable action) {
        Preconditions.checkArgument((duration > 0.0f ? 1 : 0) != 0, (Object)("Invalid delay duration: " + duration));
        final Timer timer = new Timer(duration);
        return new Scene(){

            @Override
            public void update(SceneContext context, float deltaTime) {
                timer.update(deltaTime);
                if (timer.isCompleted()) {
                    action.run();
                }
            }

            @Override
            public boolean isCompleted() {
                return timer.isCompleted();
            }
        };
    }
}

