/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.scene;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.FrameStats;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.InputDevice;
import nl.colorize.multimedialib.renderer.MediaLoader;
import nl.colorize.multimedialib.renderer.Network;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.multimedialib.scene.Updatable;
import nl.colorize.multimedialib.stage.Stage;
import nl.colorize.multimedialib.stage.StageVisitor;
import nl.colorize.util.LogHelper;
import nl.colorize.util.Platform;
import nl.colorize.util.Stopwatch;

public final class SceneContext
implements Updatable,
Renderer {
    private Renderer renderer;
    private Stopwatch timer;
    private long elapsedTime;
    private FrameStats stats;
    private Stage stage;
    private SceneInfo activeScene;
    private SceneInfo requestedScene;
    private List<Scene> globalScenes;
    private static final long FRAME_LEEWAY_MS = 5L;
    private static final float MIN_FRAME_TIME = 0.01f;
    private static final float MAX_FRAME_TIME = 0.2f;
    private static final Logger LOGGER = LogHelper.getLogger(SceneContext.class);

    public SceneContext(Renderer renderer, Stopwatch timer) {
        this.renderer = renderer;
        this.timer = timer;
        this.elapsedTime = 0L;
        this.stats = new FrameStats(renderer.getDisplayMode());
        this.stage = new Stage(renderer.getGraphicsMode(), renderer.getCanvas());
        this.globalScenes = new ArrayList<Scene>();
    }

    public boolean syncFrame() {
        long frameTime = this.timer.tick();
        this.elapsedTime += frameTime;
        long targetFrameTimeMS = this.getDisplayMode().getFrameTimeMS();
        float deltaTime = MathUtils.clamp((float)this.elapsedTime / 1000.0f, 0.01f, 0.2f);
        if (this.elapsedTime < targetFrameTimeMS - 5L) {
            return false;
        }
        this.stats.markEnd("$$frameTime");
        this.stats.markStart("$$frameUpdate");
        this.update(deltaTime);
        this.stats.markEnd("$$frameUpdate");
        this.elapsedTime = 0L;
        return true;
    }

    @Override
    public void update(float deltaTime) {
        this.getInput().update(deltaTime);
        this.stage.update(deltaTime);
        if (this.requestedScene != null) {
            this.activateRequestedScene();
        }
        this.updateSceneGraph(this.activeScene, deltaTime);
        this.updateGlobalScenes(deltaTime);
    }

    private void updateSceneGraph(SceneInfo current, float deltaTime) {
        current.scene.update(this, deltaTime);
        for (int i = current.subScenes.size() - 1; i >= 0; --i) {
            Scene subScene = current.subScenes.get(i);
            if (this.checkCompleted(current, subScene)) continue;
            subScene.update(this, deltaTime);
            this.checkCompleted(current, subScene);
        }
    }

    private boolean checkCompleted(SceneInfo parent, Scene subScene) {
        if (subScene.isCompleted()) {
            subScene.end(this);
            parent.subScenes.remove(subScene);
            return true;
        }
        return false;
    }

    private void activateRequestedScene() {
        if (this.activeScene != null) {
            this.activeScene.walk(scene -> scene.end(this));
            this.stage.clear();
        }
        this.activeScene = this.requestedScene;
        this.activeScene.walk(scene -> scene.start(this));
        this.requestedScene = null;
    }

    private void updateGlobalScenes(float deltaTime) {
        Iterator<Scene> iterator = this.globalScenes.iterator();
        while (iterator.hasNext()) {
            Scene globalScene = iterator.next();
            globalScene.update(this, deltaTime);
            if (!globalScene.isCompleted()) continue;
            iterator.remove();
        }
    }

    public void changeScene(Scene requestedScene) {
        this.requestedScene = new SceneInfo(requestedScene);
    }

    public void attach(Scene subScene) {
        if (this.requestedScene == null) {
            this.activeScene.subScenes.add(0, subScene);
            subScene.start(this);
        } else {
            this.requestedScene.subScenes.add(0, subScene);
        }
    }

    public void attach(Updatable subScene) {
        this.attach(Scene.wrap(subScene));
    }

    public void attachGlobalScene(Scene globalScene) {
        this.globalScenes.add(globalScene);
        globalScene.start(this);
    }

    public Stage getStage() {
        return this.stage;
    }

    public String getRendererName() {
        return this.getGraphics().getClass().getSimpleName().replace("GraphicsContext", "").replace("Graphics", "");
    }

    public FrameStats getFrameStats() {
        return this.stats;
    }

    public List<String> getDebugInformation() {
        ArrayList<String> info = new ArrayList<String>();
        info.add("Renderer:  " + this.getRendererName());
        info.add("Canvas:  " + this.getCanvas());
        info.add("Framerate:  " + this.stats.getActualFramerate() + " / " + this.stats.getTargetFramerate());
        info.add("Update time:  " + this.stats.getFrameUpdateTime() + "ms");
        info.add("Render time:  " + this.stats.getFrameRenderTime() + "ms");
        if (!this.stats.getCustomStats().isEmpty()) {
            info.add("--------");
        }
        for (String customStat : this.stats.getCustomStats()) {
            info.add(customStat + ":  " + this.stats.getAverageTimeMS(customStat) + "ms");
        }
        return info;
    }

    @Override
    public void start(Scene initialScene, ErrorHandler errorHandler) {
        throw new IllegalStateException("SceneContext already initialized");
    }

    @Override
    public void terminate() {
        this.renderer.terminate();
    }

    @Override
    public GraphicsMode getGraphicsMode() {
        return this.renderer.getGraphicsMode();
    }

    @Override
    public DisplayMode getDisplayMode() {
        return this.renderer.getDisplayMode();
    }

    @Override
    public StageVisitor getGraphics() {
        return this.renderer.getGraphics();
    }

    @Override
    public InputDevice getInput() {
        return this.renderer.getInput();
    }

    @Override
    public MediaLoader getMediaLoader() {
        return this.renderer.getMediaLoader();
    }

    @Override
    public Network getNetwork() {
        return this.renderer.getNetwork();
    }

    @Override
    public void takeScreenshot(File outputFile) {
        this.renderer.takeScreenshot(outputFile);
    }

    public void takeScreenshot() {
        try {
            File outputFile = new File(Platform.getUserDesktopDir(), "screenshot-" + System.currentTimeMillis() + ".png");
            this.takeScreenshot(outputFile);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to save screenshot", e);
        }
    }

    private record SceneInfo(Scene scene, List<Scene> subScenes) {
        public SceneInfo(Scene scene) {
            this(scene, new ArrayList<Scene>());
        }

        public void walk(Consumer<Scene> callback) {
            callback.accept(this.scene);
            this.subScenes.forEach(callback);
        }
    }
}

