/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.stage.Graphic2D;

public class Group
implements Iterable<Graphic2D> {
    private List<Graphic2D> graphics;

    public Group(Graphic2D initial, Graphic2D ... rest) {
        this.graphics = new ArrayList<Graphic2D>();
        this.graphics.add(initial);
        for (Graphic2D graphic : rest) {
            this.add(graphic);
        }
    }

    public Group(Collection<Graphic2D> initial) {
        Preconditions.checkArgument((!initial.isEmpty() ? 1 : 0) != 0, (Object)"Empty group");
        this.graphics = new ArrayList<Graphic2D>();
        this.graphics.addAll(initial);
    }

    public void add(Graphic2D graphic) {
        this.graphics.add(graphic);
    }

    public void add(Group group) {
        group.forEach(this::add);
    }

    public void add(Graphic2D graphic, Point2D position) {
        this.add(graphic);
        graphic.setPosition(position);
    }

    public void add(Graphic2D graphic, float x, float y) {
        this.add(graphic);
        graphic.setPosition(x, y);
    }

    public void addOffset(Graphic2D graphic, float offsetX, float offsetY) {
        this.add(graphic);
        Point2D position = this.graphics.get(0).getPosition();
        graphic.setPosition(position.getX() + offsetX, position.getY() + offsetY);
    }

    @Override
    public Iterator<Graphic2D> iterator() {
        return this.graphics.iterator();
    }

    public Stream<Graphic2D> stream() {
        return this.graphics.stream();
    }

    public <T extends Graphic2D> void forEach(Class<T> type, Consumer<T> callback) {
        this.graphics.stream().filter(graphic -> graphic.getClass().equals(type)).forEach(graphic -> callback.accept(graphic));
    }

    public Rect getBounds() {
        Rect start = this.graphics.get(0).getBounds();
        float x0 = start.getX();
        float y0 = start.getY();
        float x1 = start.getEndX();
        float y1 = start.getEndY();
        for (int i = 1; i < this.graphics.size(); ++i) {
            Rect gb = this.graphics.get(i).getBounds();
            x0 = Math.min(x0, gb.getX());
            y0 = Math.min(y0, gb.getY());
            x1 = Math.max(x1, gb.getEndX());
            y1 = Math.max(y1, gb.getEndY());
        }
        return Rect.fromPoints(x0, y0, x1, y1);
    }

    public void setVisible(boolean visible) {
        for (Graphic2D graphic : this.graphics) {
            graphic.setVisible(visible);
        }
    }
}

