/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.stage;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import nl.colorize.multimedialib.math.MathUtils;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.stage.Align;
import nl.colorize.multimedialib.stage.Graphic2D;
import nl.colorize.multimedialib.stage.OutlineFont;
import nl.colorize.util.TextUtils;

public class Text
implements Graphic2D {
    private String text;
    private List<String> lines;
    private OutlineFont font;
    private Align align;
    private float lineHeight;
    private boolean visible;
    private Point2D position;
    private float alpha;

    public Text(String text, OutlineFont font, Align align) {
        this.text = text;
        this.lines = TextUtils.LINE_SPLITTER.splitToList((CharSequence)text);
        this.font = font;
        this.align = align;
        this.lineHeight = 0.0f;
        this.visible = true;
        this.position = new Point2D(0.0f, 0.0f);
        this.alpha = 100.0f;
    }

    public Text(String text, OutlineFont font) {
        this(text, font, Align.LEFT);
    }

    public void setText(String ... lines) {
        this.setText((List<String>)ImmutableList.copyOf((Object[])lines));
    }

    public void setText(List<String> lines) {
        if (lines.isEmpty()) {
            this.text = "";
            this.lines = Collections.emptyList();
        } else if (lines.size() == 1) {
            this.text = lines.get(0);
            this.lines = TextUtils.LINE_SPLITTER.splitToList((CharSequence)this.text);
        } else {
            this.text = TextUtils.LINE_JOINER.join(lines);
            this.lines = lines;
        }
    }

    public String getText() {
        return this.text;
    }

    public List<String> getLines() {
        return this.lines;
    }

    public void forLines(BiConsumer<Integer, String> callback) {
        for (int i = 0; i < this.lines.size(); ++i) {
            callback.accept(i, this.lines.get(i));
        }
    }

    public void setFont(OutlineFont font) {
        this.font = font;
    }

    public OutlineFont getFont() {
        return this.font;
    }

    public void setAlign(Align align) {
        this.align = align;
    }

    public Align getAlign() {
        return this.align;
    }

    public void setLineHeight(float lineHeight) {
        this.lineHeight = lineHeight;
    }

    public float getLineHeight() {
        if (this.lineHeight > 0.0f) {
            return this.lineHeight;
        }
        return Math.round((float)this.font.getStyle().size() * 1.8f);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public Point2D getPosition() {
        return this.position;
    }

    public void setAlpha(float alpha) {
        this.alpha = MathUtils.clamp(alpha, 0.0f, 100.0f);
    }

    public float getAlpha() {
        return this.alpha;
    }

    @Override
    public void update(float deltaTime) {
    }

    @Override
    public Rect getBounds() {
        float approximateWidth = this.font.getStyle().size() * this.text.length();
        float approximateHeight = this.lineHeight * (float)this.lines.size();
        return new Rect(this.position.getX(), this.position.getY(), approximateWidth, approximateHeight);
    }

    @Override
    public boolean hitTest(Point2D point) {
        return false;
    }

    public String toString() {
        return "Text [" + this.text.replace("\n", " ") + "]";
    }
}

