/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.demo;

import nl.colorize.multimedialib.demo.Demo2D;
import nl.colorize.multimedialib.demo.Demo3D;
import nl.colorize.multimedialib.renderer.Canvas;
import nl.colorize.multimedialib.renderer.DisplayMode;
import nl.colorize.multimedialib.renderer.ErrorHandler;
import nl.colorize.multimedialib.renderer.GraphicsMode;
import nl.colorize.multimedialib.renderer.Renderer;
import nl.colorize.multimedialib.renderer.WindowOptions;
import nl.colorize.multimedialib.renderer.java2d.Java2DRenderer;
import nl.colorize.multimedialib.renderer.libgdx.GDXRenderer;
import nl.colorize.multimedialib.scene.Scene;
import nl.colorize.util.cli.Arg;
import nl.colorize.util.cli.CommandLineArgumentParser;
import nl.colorize.util.swing.ApplicationMenuListener;
import nl.colorize.util.swing.Popups;

public class DemoLauncher
implements ApplicationMenuListener {
    @Arg(name="-renderer", usage="Either 'java2d' or 'gdx'")
    protected String rendererName;
    @Arg(usage="Either '2d' or '3d'")
    protected String graphics;
    @Arg(defaultValue="60", usage="Framerate, default is 60 fps")
    protected int framerate;
    @Arg(name="zoom", usage="Uses a fixed canvas size to display graphics")
    protected boolean canvasZoom;

    public static void main(String[] argv) {
        CommandLineArgumentParser argParser = new CommandLineArgumentParser(DemoLauncher.class);
        DemoLauncher launcher = (DemoLauncher)argParser.parse(argv, DemoLauncher.class);
        launcher.start();
    }

    private void start() {
        Canvas canvas = this.initCanvas();
        DisplayMode displayMode = new DisplayMode(canvas, this.framerate);
        WindowOptions window = new WindowOptions("MultimediaLib - Demo", this);
        Renderer renderer = switch (this.rendererName) {
            case "java2d" -> new Java2DRenderer(displayMode, window);
            case "libgdx", "gdx" -> new GDXRenderer(this.getGraphicsMode(), displayMode, window);
            default -> throw new UnsupportedOperationException("Unknown renderer: " + this.rendererName);
        };
        Scene demo = this.createDemoScene();
        renderer.start(demo, (ErrorHandler)((Object)demo));
    }

    private Canvas initCanvas() {
        if (this.canvasZoom) {
            return Canvas.scale(800, 600);
        }
        return Canvas.flexible(800, 600);
    }

    private GraphicsMode getGraphicsMode() {
        return switch (this.graphics) {
            case "2d" -> GraphicsMode.MODE_2D;
            case "3d" -> GraphicsMode.MODE_3D;
            default -> throw new UnsupportedOperationException("Unknown graphics mode");
        };
    }

    private Scene createDemoScene() {
        return switch (this.graphics) {
            case "2d" -> new Demo2D();
            case "3d" -> new Demo3D();
            default -> throw new UnsupportedOperationException("Unknown graphics mode");
        };
    }

    public void onQuit() {
        System.exit(0);
    }

    public void onAbout() {
        Popups.message(null, (String)"MultimediaLib - demo application");
    }

    public boolean hasPreferencesMenu() {
        return false;
    }

    public void onPreferences() {
    }
}

