/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.multimedialib.math.Point2D;
import nl.colorize.multimedialib.math.Rect;
import nl.colorize.multimedialib.math.Shape;

public final class Circle
implements Shape {
    private final Point2D center;
    private final float radius;

    public Circle(Point2D center, float radius) {
        Preconditions.checkArgument((radius > 0.0f ? 1 : 0) != 0, (Object)("Invalid radius: " + radius));
        this.center = center;
        this.radius = radius;
    }

    public Circle(float x, float y, float radius) {
        this(new Point2D(x, y), radius);
    }

    public float getCenterX() {
        return this.center.getX();
    }

    public float getCenterY() {
        return this.center.getY();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.calculateDistance(p) <= this.radius;
    }

    public boolean intersects(Circle other) {
        return this.calculateDistance(other) <= this.radius + other.radius;
    }

    public float calculateDistance(Point2D p) {
        return this.center.distanceTo(p);
    }

    public float calculateDistance(Circle other) {
        return this.center.distanceTo(other.center);
    }

    @Override
    public Rect getBoundingBox() {
        return new Rect(this.center.getX() - this.radius, this.center.getY() - this.radius, 2.0f * this.radius, 2.0f * this.radius);
    }

    @Override
    public Circle reposition(Point2D offset) {
        return new Circle(this.center.getX() + offset.getX(), this.center.getY() + offset.getY(), this.radius);
    }

    public String toString() {
        return "Circle";
    }

    public Point2D getCenter() {
        return this.center;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Circle)) {
            return false;
        }
        Circle other = (Circle)o;
        if (Float.compare(this.getRadius(), other.getRadius()) != 0) {
            return false;
        }
        Point2D this$center = this.getCenter();
        Point2D other$center = other.getCenter();
        return !(this$center == null ? other$center != null : !((Object)this$center).equals(other$center));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getRadius());
        Point2D $center = this.getCenter();
        result = result * 59 + ($center == null ? 43 : ((Object)$center).hashCode());
        return result;
    }
}

