/*
 * Decompiled with CFR 0.152.
 */
package nl.colorize.multimedialib.math;

import com.google.common.base.Preconditions;
import nl.colorize.util.animation.Interpolation;

public final class Point2D {
    private final float x;
    private final float y;
    public static final float EPSILON = 0.001f;

    public Point2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public boolean isOrigin() {
        return Math.abs(this.x) < 0.001f && Math.abs(this.y) < 0.001f;
    }

    public float distanceTo(Point2D other) {
        float deltaX = Math.abs(other.x - this.x);
        float deltaY = Math.abs(other.y - this.y);
        return (float)Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public float angleTo(Point2D other) {
        double radians = Math.atan2(other.y - this.y, other.x - this.x);
        float angle = (float)Math.toDegrees(radians);
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public Point2D findCenter(Point2D other) {
        float averageX = (this.x + other.x) / 2.0f;
        float averageY = (this.y + other.y) / 2.0f;
        return new Point2D(averageX, averageY);
    }

    public Point2D interpolate(Point2D other, float delta, Interpolation method) {
        Preconditions.checkArgument((delta >= 0.0f && delta <= 1.0f ? 1 : 0) != 0, (Object)("Delta value out of range: " + delta));
        return new Point2D(method.interpolate(this.x, other.x, delta), method.interpolate(this.y, other.y, delta));
    }

    public Point2D interpolate(Point2D other, float delta) {
        return this.interpolate(other, delta, Interpolation.LINEAR);
    }

    public Point2D move(float deltaX, float deltaY) {
        return new Point2D(this.x + deltaX, this.y + deltaY);
    }

    public String toString() {
        return String.format("(%d, %d)", Math.round(this.x), Math.round(this.y));
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point2D)) {
            return false;
        }
        Point2D other = (Point2D)o;
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        return Float.compare(this.getY(), other.getY()) == 0;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        return result;
    }
}

